/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.gui.type;

import com.github.stefvanschie.inventoryframework.HumanEntityCache;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.InventoryBased;
import com.github.stefvanschie.inventoryframework.gui.type.util.NamedGui;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BrewingStandGui
extends NamedGui
implements InventoryBased {
    @NotNull
    private InventoryComponent firstBottleComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent secondBottleComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent thirdBottleComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent potionIngredientComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent blazePowderComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent playerInventoryComponent = new InventoryComponent(9, 4);

    public BrewingStandGui(@NotNull String title) {
        super(title);
    }

    public BrewingStandGui(@NotNull TextHolder title) {
        super(title);
    }

    public BrewingStandGui(@NotNull String title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    public BrewingStandGui(@NotNull TextHolder title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    @Override
    public void update() {
        if (this.isDirty()) {
            this.inventory = this.createInventory();
            this.markChanges();
        }
        this.getInventory().clear();
        this.getFirstBottleComponent().display(this.getInventory(), 0);
        this.getSecondBottleComponent().display(this.getInventory(), 1);
        this.getThirdBottleComponent().display(this.getInventory(), 2);
        this.getPotionIngredientComponent().display(this.getInventory(), 3);
        this.getBlazePowderComponent().display(this.getInventory(), 4);
        this.getPlayerInventoryComponent().display();
        this.updating = true;
        for (HumanEntity viewer : this.getViewers()) {
            ItemStack cursor = viewer.getItemOnCursor();
            viewer.setItemOnCursor(new ItemStack(Material.AIR));
            this.populateBottomInventory(viewer);
            viewer.setItemOnCursor(cursor);
        }
        if (!this.updating) {
            throw new AssertionError((Object)"Gui#isUpdating became false before Gui#update finished");
        }
        this.updating = false;
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (this.inventory == null) {
            this.update();
        }
        this.populateBottomInventory(humanEntity);
        humanEntity.openInventory(this.getInventory());
    }

    private void populateBottomInventory(@NotNull HumanEntity humanEntity) {
        if (this.getPlayerInventoryComponent().hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (!humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            this.getPlayerInventoryComponent().placeItems(humanEntity.getInventory(), 0);
        }
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public BrewingStandGui copy() {
        BrewingStandGui gui = new BrewingStandGui(this.getTitleHolder(), this.plugin);
        gui.firstBottleComponent = this.firstBottleComponent.copy();
        gui.secondBottleComponent = this.secondBottleComponent.copy();
        gui.thirdBottleComponent = this.thirdBottleComponent.copy();
        gui.potionIngredientComponent = this.potionIngredientComponent.copy();
        gui.blazePowderComponent = this.blazePowderComponent.copy();
        gui.playerInventoryComponent = this.playerInventoryComponent.copy();
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        if (rawSlot == 0) {
            this.getFirstBottleComponent().click(this, event, 0);
        } else if (rawSlot == 1) {
            this.getSecondBottleComponent().click(this, event, 0);
        } else if (rawSlot == 2) {
            this.getThirdBottleComponent().click(this, event, 0);
        } else if (rawSlot == 3) {
            this.getPotionIngredientComponent().click(this, event, 0);
        } else if (rawSlot == 4) {
            this.getBlazePowderComponent().click(this, event, 0);
        } else {
            this.getPlayerInventoryComponent().click(this, event, rawSlot - 5);
        }
    }

    @Override
    @Contract(pure=true)
    public boolean isPlayerInventoryUsed() {
        return this.getPlayerInventoryComponent().hasItem();
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        Inventory inventory = this.getTitleHolder().asInventoryTitle((InventoryHolder)this, InventoryType.BREWING);
        this.addInventory(inventory, this);
        return inventory;
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getFirstBottleComponent() {
        return this.firstBottleComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getSecondBottleComponent() {
        return this.secondBottleComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getThirdBottleComponent() {
        return this.thirdBottleComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getPotionIngredientComponent() {
        return this.potionIngredientComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getBlazePowderComponent() {
        return this.blazePowderComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getPlayerInventoryComponent() {
        return this.playerInventoryComponent;
    }

    @Nullable
    @Contract(pure=true)
    public static BrewingStandGui load(@NotNull Object instance, @NotNull InputStream inputStream, @NotNull Plugin plugin) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            return BrewingStandGui.load(instance, documentElement, plugin);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static BrewingStandGui load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        if (!element.hasAttribute("title")) {
            throw new XMLLoadException("Provided XML element's gui tag doesn't have the mandatory title attribute set");
        }
        BrewingStandGui brewingStandGui = new BrewingStandGui(element.getAttribute("title"));
        brewingStandGui.initializeOrThrow(instance, element);
        if (element.hasAttribute("populate")) {
            return brewingStandGui;
        }
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            InventoryComponent component;
            Node item = childNodes.item(index);
            if (item.getNodeType() != 1) continue;
            Element componentElement = (Element)item;
            if (!componentElement.getTagName().equalsIgnoreCase("component")) {
                throw new XMLLoadException("Gui element contains non-component tags");
            }
            if (!componentElement.hasAttribute("name")) {
                throw new XMLLoadException("Component tag does not have a name specified");
            }
            switch (componentElement.getAttribute("name")) {
                case "first-bottle": {
                    component = brewingStandGui.getFirstBottleComponent();
                    break;
                }
                case "second-bottle": {
                    component = brewingStandGui.getSecondBottleComponent();
                    break;
                }
                case "third-bottle": {
                    component = brewingStandGui.getThirdBottleComponent();
                    break;
                }
                case "potion-ingredient": {
                    component = brewingStandGui.getPotionIngredientComponent();
                    break;
                }
                case "blaze-powder": {
                    component = brewingStandGui.getBlazePowderComponent();
                    break;
                }
                case "player-inventory": {
                    component = brewingStandGui.getPlayerInventoryComponent();
                    break;
                }
                default: {
                    throw new XMLLoadException("Unknown component name");
                }
            }
            component.load(instance, componentElement, plugin);
        }
        return brewingStandGui;
    }

    @Nullable
    @Contract(pure=true)
    public static BrewingStandGui load(@NotNull Object instance, @NotNull InputStream inputStream) {
        return BrewingStandGui.load(instance, inputStream, (Plugin)JavaPlugin.getProvidingPlugin(BrewingStandGui.class));
    }

    @NotNull
    public static BrewingStandGui load(@NotNull Object instance, @NotNull Element element) {
        return BrewingStandGui.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(BrewingStandGui.class));
    }
}

