/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.MainClass;
import net.mathias2246.buildmc.PluginMain;
import net.mathias2246.buildmc.api.claims.ClaimManager;
import net.mathias2246.buildmc.api.endEvent.EndManager;
import net.mathias2246.buildmc.api.item.AbstractCustomItem;
import net.mathias2246.buildmc.api.item.CustomItemListener;
import net.mathias2246.buildmc.api.spawnEyltra.ElytraManager;
import net.mathias2246.buildmc.api.status.StatusManager;
import net.mathias2246.buildmc.claims.ClaimCommand;
import net.mathias2246.buildmc.claims.ClaimManagerImpl;
import net.mathias2246.buildmc.claims.tool.ClaimToolParticles;
import net.mathias2246.buildmc.claims.tools.ClaimSelectionTool;
import net.mathias2246.buildmc.commands.BroadcastCommandPlatform;
import net.mathias2246.buildmc.commands.BuildMcCommand;
import net.mathias2246.buildmc.commands.disabledCommands.DisableCommands;
import net.mathias2246.buildmc.endEvent.EndListener;
import net.mathias2246.buildmc.endEvent.EndManagerImpl;
import net.mathias2246.buildmc.platform.SoundManagerPaperImpl;
import net.mathias2246.buildmc.player.PlayerHeadDropDeathListener;
import net.mathias2246.buildmc.player.PlayerHeadDropModifier;
import net.mathias2246.buildmc.player.PlayerSpawnTeleportCommand;
import net.mathias2246.buildmc.player.status.PlayerStatus;
import net.mathias2246.buildmc.player.status.SetStatusCommand;
import net.mathias2246.buildmc.spawnElytra.DisableBoostListener;
import net.mathias2246.buildmc.spawnElytra.ElytraCheckListeners;
import net.mathias2246.buildmc.spawnElytra.ElytraJoinListener;
import net.mathias2246.buildmc.spawnElytra.ElytraManagerImpl;
import net.mathias2246.buildmc.spawnElytra.ElytraZoneManager;
import net.mathias2246.buildmc.status.PlayerStatusUtil;
import net.mathias2246.buildmc.status.StatusConfig;
import net.mathias2246.buildmc.util.SoundManager;
import net.mathias2246.buildmc.util.SoundUtil;
import net.mathias2246.buildmc.util.config.ConfigurationValidationException;
import net.mathias2246.buildmc.util.registry.RegistriesHolder;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

public final class Main
extends PluginMain {
    public static Logger logger;
    public static Plugin plugin;
    @Subst(value="")
    public static FileConfiguration config;
    public static File configFile;
    public static File pluginFolder;
    public static final ElytraZoneManager zoneManager;
    public static StatusConfig statusConfig;
    public static ClaimManager apiClaimManager;
    public static EndManager apiEndManager;
    private static ElytraManager apiElytraManager;

    public void onEnable() {
        plugin = this;
        logger = this.getLogger();
        pluginFolder = plugin.getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdir();
        }
        if (!(configFile = new File(plugin.getDataFolder(), "config.yml")).exists()) {
            this.saveResource("config.yml", false);
        }
        config = this.getConfig();
        CoreMain.configFile = configFile;
        CoreMain.initialize(this);
        if (config.getBoolean("claims.enabled", true)) {
            AbstractCustomItem.customItemsRegistry.addEntry(new ClaimSelectionTool((Plugin)this, Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:claim_tool")), new ClaimToolParticles.Builder()));
        }
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            ((Commands)commands.registrar()).register(new BuildMcCommand().getCommand());
            ((Commands)commands.registrar()).register(new SetStatusCommand(statusConfig).getCommand());
            ((Commands)commands.registrar()).register(new ClaimCommand().getCommand());
            ((Commands)commands.registrar()).register(new PlayerSpawnTeleportCommand().getCommand());
            ((Commands)commands.registrar()).register(new BroadcastCommandPlatform().getCommand());
        });
        try {
            EndListener.loadFromConfig();
        }
        catch (ConfigurationValidationException e) {
            throw new RuntimeException(e);
        }
        CoreMain.soundManager = new SoundManagerPaperImpl();
        apiClaimManager = new ClaimManagerImpl();
        apiEndManager = new EndManagerImpl();
        apiElytraManager = new ElytraManagerImpl(zoneManager);
    }

    public void onDisable() {
        CoreMain.stop();
    }

    private void registerEvent(@NotNull Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    @Override
    public void sendMessage(CommandSender sender, Component message) {
        sender.sendMessage(message);
    }

    @Override
    public void sendPlayerActionBar(Player player, Component message) {
        player.sendActionBar(message);
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this;
    }

    @Override
    @NotNull
    public MainClass getMainClass() {
        return this;
    }

    @Override
    @NotNull
    public SoundManager getSoundManager() {
        return CoreMain.soundManager;
    }

    @Override
    public ClaimManager getClaimManager() {
        return apiClaimManager;
    }

    @Override
    public EndManager getEndManager() {
        return apiEndManager;
    }

    @Override
    public ElytraManager getElytraManager() {
        return apiElytraManager;
    }

    @Override
    @NotNull
    public StatusManager getStatusManager() {
        return CoreMain.statusManager;
    }

    @Override
    @NotNull
    public RegistriesHolder getRegistriesHolder() {
        return CoreMain.registriesHolder;
    }

    @Override
    public void editConfiguration(@NotNull Consumer<FileConfiguration> consumer) {
        consumer.accept(config);
    }

    @Override
    public void finishLoading() {
        SoundUtil.setup();
        this.getServer().getPluginManager().registerEvents((Listener)new CustomItemListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EndListener(), (Plugin)this);
        if (config.getBoolean("spawn-elytra.enabled")) {
            this.getServer().getPluginManager().registerEvents((Listener)new ElytraJoinListener(config.getBoolean("spawn-elytra.enabled", true), config.getDouble("spawn-elytra.strength", 2.0)), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new ElytraCheckListeners(zoneManager, config.getBoolean("spawn-elytra.enabled", true), config.getDouble("spawn-elytra.strength", 2.0)), (Plugin)this);
            if (config.getBoolean("spawn-elytra.disable-rockets")) {
                this.getServer().getPluginManager().registerEvents((Listener)new DisableBoostListener(), (Plugin)this);
            }
            zoneManager.loadZoneFromConfig();
        }
        if (config.getBoolean("status.enabled")) {
            statusConfig = new StatusConfig((Plugin)this);
            CoreMain.statusManager = new PlayerStatus();
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerStatusUtil(), (Plugin)this);
        }
        if (config.getBoolean("disable-commands") && config.isList("disabled-commands")) {
            for (String fullCommand : config.getStringList("disabled-commands")) {
                String[] parts = fullCommand.split(":", 2);
                if (parts.length == 2) {
                    DisableCommands.disableCommand(parts[0], parts[1]);
                    continue;
                }
                logger.warning("Invalid command format in 'disabled-commands': " + fullCommand);
            }
        }
        if (config.getBoolean("player-head.on-death")) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerHeadDropDeathListener(new PlayerHeadDropModifier()), (Plugin)this);
        }
    }

    static {
        zoneManager = new ElytraZoneManager();
    }
}

