/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.api.claims;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.mathias2246.buildmc.api.ui.Displayable;
import net.mathias2246.buildmc.util.registry.DeferredRegistry;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Protection
implements Keyed,
Displayable,
Listener {
    @ApiStatus.Internal
    @NotNull
    public static final Collection<String> defaultProtections = new ArrayList<String>();
    @NotNull
    private final NamespacedKey key;
    private boolean isHidden;
    protected boolean isDefaultEnabled = true;

    public static boolean isHiddenProtection(@NotNull DeferredRegistry<Protection> registry, @Nullable NamespacedKey key) {
        if (key == null) {
            return false;
        }
        Optional<Protection> o = registry.getOptional(key);
        AtomicBoolean is = new AtomicBoolean(false);
        o.ifPresent(v -> is.set(v.isHidden));
        return is.get();
    }

    public Protection(@NotNull NamespacedKey key, boolean defaultEnabled) {
        this.key = key;
        this.isDefaultEnabled = defaultEnabled;
    }

    public Protection(@NotNull NamespacedKey key, boolean defaultEnabled, boolean isHidden) {
        this.key = key;
        this.isDefaultEnabled = defaultEnabled;
        this.isHidden = isHidden;
    }

    public Protection(@NotNull NamespacedKey key) {
        this.key = key;
    }

    public abstract String getTranslationBaseKey();

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean isDefaultEnabled() {
        return this.isDefaultEnabled;
    }

    public void setDefaultEnabled(boolean defaultEnabled) {
        this.isDefaultEnabled = defaultEnabled;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }
}

