/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.api.item;

import java.util.Objects;
import net.mathias2246.buildmc.api.item.ItemDropTracker;
import net.mathias2246.buildmc.api.item.ItemMetaModifier;
import net.mathias2246.buildmc.util.TaskUtil;
import net.mathias2246.buildmc.util.registry.DeferredRegistry;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCustomItem
implements Keyed {
    @NotNull
    public static final DeferredRegistry<AbstractCustomItem> customItemsRegistry = new DeferredRegistry();
    @NotNull
    private final NamespacedKey key;
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final ItemStack defaultItemStack;
    @NotNull
    public static final NamespacedKey CUSTOM_ITEM_PDC_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:custom_item"));

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public AbstractCustomItem(@NotNull Plugin plugin, @NotNull NamespacedKey key) {
        this.plugin = plugin;
        this.key = key;
        this.defaultItemStack = this.buildDefaultItemStack();
        ItemMeta itemMeta = this.defaultItemStack.getItemMeta();
        if (itemMeta instanceof ItemMeta) {
            ItemMeta meta = itemMeta;
            meta.getPersistentDataContainer().set(CUSTOM_ITEM_PDC_KEY, PersistentDataType.STRING, (Object)key.toString());
            this.defaultItemStack.setItemMeta(meta);
        }
    }

    @Nullable
    public static NamespacedKey getCustomItemKey(@Nullable ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof ItemMeta)) {
            return null;
        }
        ItemMeta meta = itemMeta;
        String s = (String)meta.getPersistentDataContainer().get(CUSTOM_ITEM_PDC_KEY, PersistentDataType.STRING);
        if (s == null) {
            return null;
        }
        return NamespacedKey.fromString((String)s);
    }

    public void giveToPlayer(@NotNull Player player, int amount) {
        ItemStack i = this.defaultItemStack.clone();
        i.setAmount(amount);
        player.getInventory().addItem(new ItemStack[]{i});
    }

    public void giveToPlayer(@NotNull Player player) {
        player.getInventory().addItem(new ItemStack[]{this.defaultItemStack.clone()});
    }

    public void giveToPlayer(@NotNull Player player, @NotNull ItemMetaModifier modifier) {
        ItemStack i = this.defaultItemStack.clone();
        ItemMeta itemMeta = i.getItemMeta();
        if (itemMeta instanceof ItemMeta) {
            ItemMeta meta = itemMeta;
            modifier.modifyMeta(meta, player);
            i.setItemMeta(meta);
        }
        player.getInventory().addItem(new ItemStack[]{i});
    }

    public boolean isThis(@Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof ItemMeta)) {
            return false;
        }
        ItemMeta meta = itemMeta;
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        return Objects.equals(pdc.get(CUSTOM_ITEM_PDC_KEY, PersistentDataType.STRING), this.key.toString());
    }

    public abstract boolean canUse(@NotNull ItemStack var1, @NotNull PlayerInteractEvent var2);

    @ApiStatus.Internal
    public void onInteractEvent(@NotNull ItemStack item, @NotNull PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        this.onInteract(item, event);
        Player player = event.getPlayer();
        TaskUtil.deferForEntity(this.plugin, (Entity)player, task -> {
            Location at;
            if (ItemDropTracker.droppedRecently(player)) {
                return;
            }
            Action action = event.getAction();
            Location location = at = event.getClickedBlock() != null ? event.getClickedBlock().getLocation() : player.getLocation();
            if (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) {
                this.onLeftClick(item, at, event);
            } else if (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) {
                this.onRightClick(item, at, event);
            }
        });
    }

    protected abstract void onInteract(@NotNull ItemStack var1, @NotNull PlayerInteractEvent var2);

    protected abstract void onLeftClick(@NotNull ItemStack var1, @NotNull Location var2, @NotNull PlayerInteractEvent var3);

    protected abstract void onRightClick(@NotNull ItemStack var1, @NotNull Location var2, @NotNull PlayerInteractEvent var3);

    @NotNull
    protected abstract ItemStack buildDefaultItemStack();
}

