/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.api.item;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ItemDropTracker
implements Listener {
    private static ItemDropTracker instance;
    private final Map<UUID, Long> lastDropNano = new HashMap<UUID, Long>();
    private final long sameTickNanos;

    public ItemDropTracker(Plugin plugin) {
        this(plugin, 100000000L);
    }

    public ItemDropTracker(Plugin plugin, long sameTickNanos) {
        if (instance != null) {
            throw new IllegalStateException("ItemDropTracker already initialized!");
        }
        instance = this;
        this.sameTickNanos = sameTickNanos;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        Bukkit.getGlobalRegionScheduler().runAtFixedRate(plugin, task -> {
            long cutoff = System.nanoTime() - sameTickNanos * 10L;
            this.lastDropNano.entrySet().removeIf(e -> (Long)e.getValue() < cutoff);
        }, 600L, 600L);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onItemDrop(PlayerDropItemEvent event) {
        this.lastDropNano.put(event.getPlayer().getUniqueId(), System.nanoTime());
    }

    public static boolean droppedRecently(Player player) {
        if (instance == null) {
            return false;
        }
        Long last = ItemDropTracker.instance.lastDropNano.get(player.getUniqueId());
        return last != null && System.nanoTime() - last <= ItemDropTracker.instance.sameTickNanos;
    }
}

