/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.math.BlockPosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.item.AbstractCustomItem;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.claims.claimSubCommands.CreateClaimSubCommand;
import net.mathias2246.buildmc.claims.claimSubCommands.WhitelistSubCommand;
import net.mathias2246.buildmc.claims.tool.ClaimToolItemMetaModifier;
import net.mathias2246.buildmc.claims.tools.ClaimSelectionTool;
import net.mathias2246.buildmc.commands.CustomCommand;
import net.mathias2246.buildmc.commands.claim.ClaimProtections;
import net.mathias2246.buildmc.commands.claim.ClaimRemove;
import net.mathias2246.buildmc.commands.claim.ClaimWho;
import net.mathias2246.buildmc.ui.claims.ClaimSelectMenu;
import net.mathias2246.buildmc.util.CommandUtil;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public class ClaimCommand
implements CustomCommand {
    @NotNull
    private static final ClaimToolItemMetaModifier claimToolNameAndTooltip = new ClaimToolItemMetaModifier();
    private static ClaimSelectionTool claimTool;

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        LiteralArgumentBuilder cmd = Commands.literal((String)"claim");
        cmd.requires(command -> {
            boolean t = Main.config.getBoolean("claims.enabled", true);
            claimTool = !t ? null : (ClaimSelectionTool)AbstractCustomItem.customItemsRegistry.get(Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:claim_tool")).key());
            return t;
        });
        cmd.executes(ClaimCommand::handleEdit);
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"claimtool").requires(command -> Main.config.getBoolean("claims.tool.enable-give-command", true))).executes(ClaimCommand::handleGetClaimTool));
        cmd.then(Commands.literal((String)"edit").executes(ClaimCommand::handleEdit));
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"who").executes(ClaimCommand::handleWho)).then(Commands.argument((String)"position", (ArgumentType)ArgumentTypes.blockPosition()).executes(ClaimCommand::handleWhoAt)));
        cmd.then(Commands.literal((String)"help").executes(ClaimCommand::handleHelp));
        cmd.then(CreateClaimSubCommand.createSubCommand());
        cmd.then(Commands.literal((String)"remove").then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests(ClaimCommand::claimTypesSuggestions).then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.word()).suggests(ClaimCommand::claimIdsSuggestions).executes(command -> {
            CommandSender sender = ((CommandSourceStack)command.getSource()).getSender();
            Player patt0$temp = net.mathias2246.buildmc.commands.CommandUtil.requiresPlayer(sender);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = StringArgumentType.getString((CommandContext)command, (String)"type").toLowerCase();
            String claimName = StringArgumentType.getString((CommandContext)command, (String)"claim");
            return ClaimRemove.removeClaimCommand(player, type, claimName);
        }))));
        cmd.then(WhitelistSubCommand.createSubCommand());
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"protections").requires(command -> !CoreMain.plugin.getConfig().getBoolean("claims.hide-all-protections"))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests(ClaimCommand::claimTypesSuggestions).then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.word()).suggests(ClaimCommand::claimIdsSuggestions).then(Commands.argument((String)"key", (ArgumentType)ArgumentTypes.namespacedKey()).suggests((ctx, builder) -> {
            String remaining = builder.getRemaining();
            Iterator<Protection> iterator = CoreMain.protectionsRegistry.iterator();
            while (iterator.hasNext()) {
                Protection flag = iterator.next();
                String s = flag.getKey().toString();
                if (flag.isHidden() || !s.startsWith(remaining.toLowerCase())) continue;
                builder.suggest(s);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.word()).suggests(CommandUtil::booleanSuggestion).executes(command -> {
            boolean value;
            CommandSender sender = ((CommandSourceStack)command.getSource()).getSender();
            Player patt0$temp = net.mathias2246.buildmc.commands.CommandUtil.requiresPlayer(sender);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String type = StringArgumentType.getString((CommandContext)command, (String)"type").toLowerCase();
            String claimName = StringArgumentType.getString((CommandContext)command, (String)"claim");
            NamespacedKey flag = (NamespacedKey)command.getArgument("key", NamespacedKey.class);
            String valueStr = StringArgumentType.getString((CommandContext)command, (String)"value").toLowerCase();
            if (valueStr.equals("true")) {
                value = true;
            } else if (valueStr.equals("false")) {
                value = false;
            } else {
                player.sendMessage((Component)Component.translatable("messages.claims.protections.invalid-value"));
                return 0;
            }
            if (flag == null || Protection.isHiddenProtection(CoreMain.protectionsRegistry, flag)) {
                player.sendMessage((Component)Component.translatable("messages.claims.protections.invalid-flag"));
                return 0;
            }
            return ClaimProtections.changeClaimProtections(player, flag, value, type, claimName);
        }))))));
        return cmd.build();
    }

    protected static int handleEdit(CommandContext<CommandSourceStack> command) {
        Player player = net.mathias2246.buildmc.commands.CommandUtil.requiresPlayer(((CommandSourceStack)command.getSource()).getSender());
        if (!(player instanceof Player)) {
            return 0;
        }
        Player player2 = player;
        ClaimSelectMenu.open(player2);
        return 1;
    }

    protected static int handleGetClaimTool(CommandContext<CommandSourceStack> command) {
        Player player = net.mathias2246.buildmc.commands.CommandUtil.requiresPlayer(((CommandSourceStack)command.getSource()).getSender());
        if (!(player instanceof Player)) {
            return 0;
        }
        Player player2 = player;
        if (player2.getInventory().firstEmpty() == -1) {
            player2.sendMessage((Component)Component.translatable("messages.claims.tool.full-inventory"));
            return 0;
        }
        claimTool.giveToPlayer(player2, claimToolNameAndTooltip);
        player2.sendMessage((Component)Component.translatable("messages.claims.tool.give-success"));
        return 1;
    }

    protected static int handleWho(CommandContext<CommandSourceStack> command) {
        Player player = net.mathias2246.buildmc.commands.CommandUtil.requiresPlayer(((CommandSourceStack)command.getSource()).getSender());
        if (!(player instanceof Player)) {
            return 0;
        }
        Player player2 = player;
        return ClaimWho.whoClaimCommand(player2, player2.getLocation());
    }

    protected static int handleWhoAt(CommandContext<CommandSourceStack> command) {
        Location l;
        Player player = net.mathias2246.buildmc.commands.CommandUtil.requiresPlayer(((CommandSourceStack)command.getSource()).getSender());
        if (!(player instanceof Player)) {
            return 0;
        }
        Player player2 = player;
        try {
            l = ((BlockPosition)((BlockPositionResolver)command.getArgument("position", BlockPositionResolver.class)).resolve((CommandSourceStack)command.getSource())).toLocation(player2.getWorld());
        }
        catch (CommandSyntaxException e) {
            player2.sendMessage((Component)Component.translatable("messages.error.general"));
            return 0;
        }
        return ClaimWho.whoClaimCommand(player2, l);
    }

    protected static int handleHelp(CommandContext<CommandSourceStack> command) {
        CommandSender sender = ((CommandSourceStack)command.getSource()).getSender();
        sender.sendMessage((Component)Component.translatable("messages.claims.help-message"));
        return 1;
    }

    public static CompletableFuture<Suggestions> claimTypesSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Player player;
        ArrayList<String> suggestions = new ArrayList<String>(List.of("player", "team"));
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        if (commandSender instanceof Player && (player = (Player)commandSender).hasPermission("buildmc.admin")) {
            suggestions.add("server");
            suggestions.add("placeholder");
        }
        for (String suggestion : suggestions) {
            if (!suggestion.startsWith(builder.getRemaining().toLowerCase())) continue;
            builder.suggest(suggestion);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> claimIdsSuggestions(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        block6: {
            String type;
            Player player;
            block7: {
                block5: {
                    CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
                    if (!(sender instanceof Player)) {
                        return builder.buildFuture();
                    }
                    player = (Player)sender;
                    type = StringArgumentType.getString(ctx, (String)"type");
                    if (!type.equalsIgnoreCase("player")) break block5;
                    List claimIds = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                    Iterator iterator = claimIds.iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        String name = ClaimManager.getClaimNameById(id);
                        if (name == null || !name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                        builder.suggest(name);
                    }
                    break block6;
                }
                if (!type.equalsIgnoreCase("team")) break block7;
                Team team = ClaimManager.getPlayerTeam(player);
                if (team == null) break block6;
                List claimIds = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                Iterator id = claimIds.iterator();
                while (id.hasNext()) {
                    long id2 = (Long)id.next();
                    String name = ClaimManager.getClaimNameById(id2);
                    if (name == null || !name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(name);
                }
                break block6;
            }
            if (type.equalsIgnoreCase("server") && player.hasPermission("buildmc.admin")) {
                List<Long> claimIds = ClaimManager.serverClaims;
                for (long id : claimIds) {
                    String name = ClaimManager.getClaimNameById(id);
                    if (name == null || !name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(name);
                }
            }
        }
        return builder.buildFuture();
    }
}

