/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.event.claims.ClaimCreateEvent;
import net.mathias2246.buildmc.api.event.claims.ClaimRemoveEvent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ClaimManager {
    @NotNull
    public static final NamespacedKey CLAIM_PCD_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:claim_id"));
    public static Map<String, List<Long>> teamOwner;
    public static Map<UUID, List<Long>> playerOwner;
    public static Map<String, Integer> teamRemainingClaims;
    public static Map<String, Integer> playerRemainingClaims;
    public static List<Long> serverClaims;
    public static List<Long> placeholderClaims;
    public static boolean isDimensionBlacklist;
    @NotNull
    public static List<World> dimensionList;

    public static boolean isWorldAllowed(@NotNull World world) {
        if (isDimensionBlacklist) {
            return !dimensionList.contains(world);
        }
        return dimensionList.contains(world);
    }

    @Nullable
    public static Team getPlayerTeam(@NotNull Player player) {
        return player.getScoreboard().getEntryTeam(player.getName());
    }

    public static boolean isPlayerAllowed(@NotNull Player player, @NotNull Collection<NamespacedKey> protections, Location location) {
        Claim claim;
        if (player.hasPermission("buildmc.bypass-claims")) {
            return true;
        }
        try {
            claim = ClaimManager.getClaim(location);
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("SQL Error while getting claim: " + String.valueOf(e));
            return true;
        }
        if (claim == null) {
            return true;
        }
        if (claim.getType() == ClaimType.PLACEHOLDER) {
            return true;
        }
        if (claim.getWhitelistedPlayers().contains(player.getUniqueId())) {
            return true;
        }
        String playerId = player.getUniqueId().toString();
        switch (claim.getType()) {
            case SERVER: {
                return !ClaimManager.hasAllProtectionKeys(claim, protections);
            }
            case PLAYER: {
                if (Objects.equals(claim.getOwnerId(), playerId)) {
                    return true;
                }
                return !ClaimManager.hasAllProtectionKeys(claim, protections);
            }
            case TEAM: {
                Team playerTeam = ClaimManager.getPlayerTeam(player);
                if (playerTeam != null && Objects.equals(playerTeam.getName(), claim.getOwnerId())) {
                    return true;
                }
                return !ClaimManager.hasAllProtectionKeys(claim, protections);
            }
        }
        return true;
    }

    public static boolean isPlayerAllowed(@NotNull Player player, @NotNull Collection<NamespacedKey> protections, @Nullable Claim claim) {
        if (player.hasPermission("buildmc.bypass-claims")) {
            return true;
        }
        if (claim == null) {
            return true;
        }
        if (claim.getType() == ClaimType.PLACEHOLDER) {
            return true;
        }
        if (claim.getWhitelistedPlayers().contains(player.getUniqueId())) {
            return true;
        }
        String playerId = player.getUniqueId().toString();
        switch (claim.getType()) {
            case SERVER: {
                return !ClaimManager.hasAnyProtection(claim, protections);
            }
            case PLAYER: {
                if (Objects.equals(claim.getOwnerId(), playerId)) {
                    return true;
                }
                return !ClaimManager.hasAnyProtection(claim, protections);
            }
            case TEAM: {
                Team playerTeam = ClaimManager.getPlayerTeam(player);
                if (playerTeam != null && Objects.equals(playerTeam.getName(), claim.getOwnerId())) {
                    return true;
                }
                return !ClaimManager.hasAnyProtection(claim, protections);
            }
        }
        return true;
    }

    public static boolean isPlayerAllowed(@NotNull Player player, @NotNull NamespacedKey protection, @Nullable Claim claim) {
        if (claim == null) {
            return true;
        }
        if (player.hasPermission("buildmc.bypass-claims")) {
            return true;
        }
        if (claim.getType() == ClaimType.PLACEHOLDER) {
            return true;
        }
        if (claim.getWhitelistedPlayers().contains(player.getUniqueId())) {
            return true;
        }
        String playerId = player.getUniqueId().toString();
        switch (claim.getType()) {
            case SERVER: {
                return !ClaimManager.hasProtection(claim, protection);
            }
            case PLAYER: {
                if (Objects.equals(claim.getOwnerId(), playerId)) {
                    return true;
                }
                return !ClaimManager.hasProtection(claim, protection);
            }
            case TEAM: {
                Team playerTeam = ClaimManager.getPlayerTeam(player);
                if (playerTeam != null && Objects.equals(playerTeam.getName(), claim.getOwnerId())) {
                    return true;
                }
                return !ClaimManager.hasProtection(claim, protection);
            }
        }
        return true;
    }

    public static boolean isPlayerAllowed(@NotNull Player player, @NotNull NamespacedKey protection, Location location) {
        Claim claim;
        if (player.hasPermission("buildmc.bypass-claims")) {
            return true;
        }
        try {
            claim = ClaimManager.getClaim(location);
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("SQL Error while getting claim: " + String.valueOf(e));
            return true;
        }
        if (claim == null) {
            return true;
        }
        if (claim.getType() == ClaimType.PLACEHOLDER) {
            return true;
        }
        if (claim.getWhitelistedPlayers().contains(player.getUniqueId())) {
            return true;
        }
        String playerId = player.getUniqueId().toString();
        switch (claim.getType()) {
            case SERVER: {
                return !ClaimManager.hasProtection(claim, protection);
            }
            case PLAYER: {
                if (Objects.equals(claim.getOwnerId(), playerId)) {
                    return true;
                }
                return !ClaimManager.hasProtection(claim, protection);
            }
            case TEAM: {
                Team playerTeam = ClaimManager.getPlayerTeam(player);
                if (playerTeam != null && Objects.equals(playerTeam.getName(), claim.getOwnerId())) {
                    return true;
                }
                return !ClaimManager.hasProtection(claim, protection);
            }
        }
        return true;
    }

    public static boolean hasAnyProtection(Claim claim, Collection<NamespacedKey> protections) {
        for (NamespacedKey key : protections) {
            if (!claim.hasProtection(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasProtection(Claim claim, NamespacedKey protection) {
        return claim.hasProtection(protection);
    }

    public static boolean hasAllProtections(Claim claim, Collection<String> flags) {
        return new HashSet<String>(claim.getProtections()).containsAll(flags);
    }

    public static boolean hasAllProtectionKeys(Claim claim, Collection<NamespacedKey> keys) {
        for (NamespacedKey f : keys) {
            if (claim.hasProtection(f)) continue;
            return false;
        }
        return true;
    }

    public static boolean isClaimInArea(UUID worldID, int chunkX1, int chunkZ1, int chunkX2, int chunkZ2) throws SQLException {
        return CoreMain.claimTable.doesClaimExistInArea(CoreMain.databaseManager.getConnection(), worldID, chunkX1, chunkZ1, chunkX2, chunkZ2);
    }

    public static List<Claim> getClaimsInArea(Location pos1, Location pos2) throws SQLException, IllegalArgumentException {
        UUID worldId2;
        if (pos1 == null || pos2 == null) {
            throw new IllegalArgumentException("Positions cannot be null.");
        }
        if (pos1.getWorld() == null || pos2.getWorld() == null) {
            throw new IllegalArgumentException("Both locations must have a world.");
        }
        UUID worldId1 = pos1.getWorld().getUID();
        if (!worldId1.equals(worldId2 = pos2.getWorld().getUID())) {
            throw new IllegalArgumentException("Locations must be in the same world.");
        }
        int chunkX1 = pos1.getBlockX() >> 4;
        int chunkZ1 = pos1.getBlockZ() >> 4;
        int chunkX2 = pos2.getBlockX() >> 4;
        int chunkZ2 = pos2.getBlockZ() >> 4;
        return CoreMain.claimTable.getOverlappingClaimsInArea(CoreMain.databaseManager.getConnection(), worldId1, chunkX1, chunkZ1, chunkX2, chunkZ2);
    }

    public static boolean isClaimed(Chunk chunk) {
        return chunk.getPersistentDataContainer().has(CLAIM_PCD_KEY);
    }

    @Nullable
    public static Long getClaimId(Chunk chunk) {
        return (Long)chunk.getPersistentDataContainer().get(CLAIM_PCD_KEY, PersistentDataType.LONG);
    }

    @Nullable
    public static Claim getClaim(Chunk chunk) throws SQLException {
        Long claimId = ClaimManager.getClaimId(chunk);
        if (claimId == null) {
            return null;
        }
        return CoreMain.claimTable.getClaimById(CoreMain.databaseManager.getConnection(), claimId);
    }

    @Nullable
    public static Claim getClaimByID(long claimID) {
        try {
            return CoreMain.claimTable.getClaimById(CoreMain.databaseManager.getConnection(), claimID);
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("SQL Error while trying to get a claim by ID: " + String.valueOf(e));
            return null;
        }
    }

    @Nullable
    public static Claim getClaim(Location location) throws SQLException {
        Chunk chunk = location.getChunk();
        return ClaimManager.getClaim(chunk);
    }

    public static List<Claim> getAllClaims() throws SQLException {
        return CoreMain.claimTable.getAllClaims(CoreMain.databaseManager.getConnection());
    }

    public static boolean tryClaimPlayerArea(@NotNull Player player, String claimName, Location pos1, Location pos2) {
        return ClaimManager.tryClaimArea(ClaimType.PLAYER, player.getUniqueId().toString(), claimName, pos1, pos2);
    }

    public static boolean tryClaimTeamArea(@NotNull Team team, String claimName, Location pos1, Location pos2) {
        return ClaimManager.tryClaimArea(ClaimType.TEAM, team.getName(), claimName, pos1, pos2);
    }

    public static boolean tryClaimServerArea(String claimName, Location pos1, Location pos2) {
        return ClaimManager.tryClaimArea(ClaimType.SERVER, "server", claimName, pos1, pos2);
    }

    public static boolean tryClaimPlaceholderArea(String claimName, Location pos1, Location pos2) {
        return ClaimManager.tryClaimArea(ClaimType.PLACEHOLDER, "server", claimName, pos1, pos2);
    }

    public static boolean tryClaimArea(@NotNull ClaimType type, @NotNull String ownerId, @NotNull String claimName, @NotNull Location pos1, @NotNull Location pos2) {
        long claimId;
        if (pos1.getWorld() == null || pos2.getWorld() == null) {
            return false;
        }
        if (pos1.getWorld() != pos2.getWorld()) {
            return false;
        }
        UUID worldId = pos1.getWorld().getUID();
        int chunkX1 = pos1.getBlockX() >> 4;
        int chunkZ1 = pos1.getBlockZ() >> 4;
        int chunkX2 = pos2.getBlockX() >> 4;
        int chunkZ2 = pos2.getBlockZ() >> 4;
        Claim claim = new Claim(null, type, ownerId, worldId, chunkX1, chunkZ1, chunkX2, chunkZ2, claimName, List.of(), new ArrayList<String>());
        try {
            claimId = CoreMain.claimTable.insertClaim(CoreMain.databaseManager.getConnection(), claim);
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("Failed to insert claim into database: " + String.valueOf(e));
            return false;
        }
        if (claimId == -1L) {
            return false;
        }
        claim.setID(claimId);
        int startX = Math.min(chunkX1, chunkX2);
        int endX = Math.max(chunkX1, chunkX2);
        int startZ = Math.min(chunkZ1, chunkZ2);
        int endZ = Math.max(chunkZ1, chunkZ2);
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                Chunk chunk = pos1.getWorld().getChunkAt(x, z);
                PersistentDataContainer pdc = chunk.getPersistentDataContainer();
                pdc.set(CLAIM_PCD_KEY, PersistentDataType.LONG, (Object)claimId);
            }
        }
        ClaimCreateEvent e = new ClaimCreateEvent(claim);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return false;
        }
        switch (type) {
            case PLAYER: {
                UUID uuid = UUID.fromString(ownerId);
                playerOwner.computeIfAbsent(uuid, k -> new ArrayList()).add(claimId);
                break;
            }
            case TEAM: {
                teamOwner.computeIfAbsent(ownerId, k -> new ArrayList()).add(claimId);
                break;
            }
            case SERVER: {
                serverClaims.add(claimId);
                break;
            }
            case PLACEHOLDER: {
                placeholderClaims.add(claimId);
            }
        }
        return true;
    }

    public static void addPlayerToWhitelist(long claimID, UUID playerID) {
        Claim claim = null;
        try {
            claim = CoreMain.claimTable.getClaimById(CoreMain.databaseManager.getConnection(), claimID);
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("SQL error while getting claim: " + String.valueOf(e));
        }
        if (claim == null) {
            return;
        }
        claim.addWhitelistedPlayer(playerID);
        try {
            CoreMain.claimTable.addWhitelistedPlayer(CoreMain.databaseManager.getConnection(), claimID, playerID);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removePlayerFromWhitelist(long claimID, UUID playerID) {
        Claim claim = null;
        try {
            claim = CoreMain.claimTable.getClaimById(CoreMain.databaseManager.getConnection(), claimID);
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("SQL error while getting claim: " + String.valueOf(e));
        }
        if (claim == null) {
            return;
        }
        claim.removeWhitelistedPlayer(playerID);
        try {
            CoreMain.claimTable.removeWhitelistedPlayer(CoreMain.databaseManager.getConnection(), claimID, playerID);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addProtection(long claimId, @NotNull Protection protection) {
        try {
            CoreMain.claimTable.addProtectionFlag(CoreMain.databaseManager.getConnection(), claimId, protection.getKey());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addProtection(long claimId, @NotNull NamespacedKey protection) {
        try {
            CoreMain.claimTable.addProtectionFlag(CoreMain.databaseManager.getConnection(), claimId, protection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeProtection(long claimId, @NotNull Protection protection) {
        try {
            CoreMain.claimTable.removeProtectionFlag(CoreMain.databaseManager.getConnection(), claimId, protection.getKey());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeProtection(long claimId, @NotNull NamespacedKey protection) {
        try {
            CoreMain.claimTable.removeProtectionFlag(CoreMain.databaseManager.getConnection(), claimId, protection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static String getClaimNameById(long claimId) {
        String name = null;
        try {
            name = CoreMain.claimTable.getClaimNameById(CoreMain.databaseManager.getConnection(), claimId);
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("SQL Error while trying to get name by ID " + String.valueOf(e));
        }
        return name;
    }

    public static boolean removeClaimById(long claimId) {
        ClaimRemoveEvent event = new ClaimRemoveEvent(Objects.requireNonNull(ClaimManager.getClaimByID(claimId)));
        Bukkit.getPluginManager().callEvent((Event)event);
        try {
            CoreMain.claimTable.deleteClaimById(CoreMain.databaseManager.getConnection(), claimId);
        }
        catch (SQLException e) {
            CoreMain.plugin.getLogger().severe("Failed to remove claim from database: " + String.valueOf(e));
            return false;
        }
        return true;
    }

    public static boolean doesOwnerHaveClaimWithName(String ownerId, String claimName) throws SQLException {
        return CoreMain.claimTable.doesOwnerHaveClaimWithName(CoreMain.databaseManager.getConnection(), ownerId, claimName);
    }

    @Nullable
    public static Integer getRemainingTeamClaims(String teamName) {
        return teamRemainingClaims.get(teamName);
    }

    @Nullable
    public static Integer getRemainingPlayerClaims(String playerUUID) {
        return playerRemainingClaims.get(playerUUID);
    }

    @Nullable
    public static Integer getRemainingPlayerClaims(UUID playerUUID) {
        return playerRemainingClaims.get(playerUUID.toString());
    }

    public static void setRemainingTeamClaims(String teamName, @Nullable Integer remainingClaims) {
        if (remainingClaims == null) {
            teamRemainingClaims.remove(teamName);
        } else {
            teamRemainingClaims.put(teamName, remainingClaims);
        }
    }

    public static void setRemainingPlayerClaims(String playerUUID, @Nullable Integer remainingClaims) {
        if (remainingClaims == null) {
            playerRemainingClaims.remove(playerUUID);
        } else {
            playerRemainingClaims.put(playerUUID, remainingClaims);
        }
    }

    public static void setRemainingPlayerClaims(UUID playerUUID, @Nullable Integer remainingClaims) {
        ClaimManager.setRemainingPlayerClaims(playerUUID.toString(), remainingClaims);
    }

    static {
        isDimensionBlacklist = true;
        dimensionList = new ArrayList<World>();
    }
}

