/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.claimSubCommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.commands.CommandUtil;
import net.mathias2246.buildmc.commands.claim.ClaimWhitelist;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public class WhitelistSubCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> createSubCommand() {
        return Commands.literal((String)"whitelist").then(Commands.argument((String)"action", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            List<String> actions = List.of("add", "remove");
            for (String action : actions) {
                if (!action.startsWith(builder.getRemaining())) continue;
                builder.suggest(action);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Player player;
            ArrayList<String> suggestions = new ArrayList<String>(List.of("player", "team"));
            CommandSender patt0$temp = ((CommandSourceStack)ctx.getSource()).getSender();
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("buildmc.admin")) {
                suggestions.add("server");
            }
            for (String suggestion : suggestions) {
                if (!suggestion.startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(suggestion);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            if (!(sender instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)sender;
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            List<Object> claimIds = List.of();
            if (type.equalsIgnoreCase("player")) {
                claimIds = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
            } else if (type.equalsIgnoreCase("team")) {
                Team team = ClaimManager.getPlayerTeam(player);
                if (team != null) {
                    claimIds = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
            } else if (type.equalsIgnoreCase("server") && player.hasPermission("buildmc.admin")) {
                claimIds = ClaimManager.serverClaims;
            }
            Iterator iterator = claimIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                String name = ClaimManager.getClaimNameById(id);
                if (name == null || !name.startsWith(builder.getRemaining())) continue;
                builder.suggest(name);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Object team;
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            if (!(sender instanceof Player)) {
                return builder.buildFuture();
            }
            Player player = (Player)sender;
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            String claimName = StringArgumentType.getString((CommandContext)ctx, (String)"claim");
            Claim claim = null;
            List<Object> claimIds = List.of();
            if (type.equalsIgnoreCase("player")) {
                claimIds = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
            } else if (type.equalsIgnoreCase("team")) {
                team = ClaimManager.getPlayerTeam(player);
                if (team != null) {
                    claimIds = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                }
            } else if (type.equalsIgnoreCase("server") && player.hasPermission("buildmc.admin")) {
                claimIds = ClaimManager.serverClaims;
            }
            team = claimIds.iterator();
            while (team.hasNext()) {
                long id = (Long)team.next();
                if (!claimName.equalsIgnoreCase(ClaimManager.getClaimNameById(id))) continue;
                claim = ClaimManager.getClaimByID(id);
                break;
            }
            if (claim == null) {
                return builder.buildFuture();
            }
            List<UUID> whitelist = claim.getWhitelistedPlayers();
            boolean isServer = claim.getType() == ClaimType.SERVER;
            for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                Team team2;
                if (offlinePlayer.getName() == null || !isServer && offlinePlayer.getUniqueId().equals(player.getUniqueId()) || whitelist.contains(offlinePlayer.getUniqueId()) || type.equalsIgnoreCase("team") && (team2 = ClaimManager.getPlayerTeam(player)) != null && team2.hasEntry(offlinePlayer.getName()) || !offlinePlayer.getName().startsWith(builder.getRemaining())) continue;
                builder.suggest(offlinePlayer.getName());
            }
            return builder.buildFuture();
        }).executes(command -> {
            CommandSender sender = ((CommandSourceStack)command.getSource()).getSender();
            Player patt0$temp = CommandUtil.requiresPlayer(sender);
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            String action = StringArgumentType.getString((CommandContext)command, (String)"action").toLowerCase();
            String type = StringArgumentType.getString((CommandContext)command, (String)"type").toLowerCase();
            String claimName = StringArgumentType.getString((CommandContext)command, (String)"claim");
            String targetPlayerName = StringArgumentType.getString((CommandContext)command, (String)"player");
            return ClaimWhitelist.whitelistClaimCommand(player, type, claimName, action, targetPlayerName);
        })))));
    }
}

