/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.claims.protections.blocks;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.item.ItemUtil;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.gui.type.util.Gui;
import net.mathias2246.buildmc.ui.UIUtil;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoneMeal
extends Protection {
    public BoneMeal(@Nullable ConfigurationSection section) {
        super(Objects.requireNonNull(NamespacedKey.fromString((String)"buildmc:bone_meal_interactions")), section != null ? section.getBoolean("default", true) : true, section != null && section.getBoolean("is-hidden", false));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBonemealUse(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getItem() == null || event.getItem().getType() != Material.BONE_MEAL) {
            return;
        }
        Player player = event.getPlayer();
        if (!ClaimManager.isPlayerAllowed(player, this.getKey(), event.getClickedBlock().getLocation())) {
            event.setCancelled(true);
            CoreMain.mainClass.sendPlayerActionBar(player, Component.translatable("messages.claims.not-accessible.interact"));
        }
    }

    @Override
    public String getTranslationBaseKey() {
        return "claims.flags.interaction-bonemeal";
    }

    @Override
    @NotNull
    public GuiItem getDisplay(@NotNull Player uiHolder, @NotNull Gui gui) {
        String t = this.getTranslationBaseKey();
        ItemStack displayBase = new ItemStack(Material.BONE_MEAL);
        ItemUtil.editMeta(displayBase, meta -> {
            meta.setItemName(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".name")));
            meta.setLore(List.of(LegacyComponentSerializer.legacySection().serialize(Message.msg(uiHolder, t + ".lore")).split("\n")));
        });
        return new GuiItem(displayBase, UIUtil.noInteract);
    }
}

