/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.commands.claim;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.Protection;
import net.mathias2246.buildmc.api.event.claims.ClaimProtectionChangeEvent;
import net.mathias2246.buildmc.claims.ClaimLogger;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public class ClaimProtections {
    public static int changeClaimProtections(@NotNull Player player, @NotNull NamespacedKey flag, boolean value, String type, String name) {
        if (Protection.isHiddenProtection(CoreMain.protectionsRegistry, flag)) {
            CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.protections.invalid-flag"));
            return 0;
        }
        Claim claim = null;
        long claimId = -1L;
        block5 : switch (type) {
            case "player": {
                List ids = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), List.of());
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    if (!name.equalsIgnoreCase(ClaimManager.getClaimNameById(id))) continue;
                    claim = ClaimManager.getClaimByID(id);
                    claimId = id;
                    break block5;
                }
                break;
            }
            case "team": {
                Team team = ClaimManager.getPlayerTeam(player);
                if (team == null) {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.error.not-in-a-team"));
                    return 0;
                }
                List ids = ClaimManager.teamOwner.getOrDefault(team.getName(), List.of());
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    if (!name.equalsIgnoreCase(ClaimManager.getClaimNameById(id))) continue;
                    claim = ClaimManager.getClaimByID(id);
                    claimId = id;
                    break block5;
                }
                break;
            }
            case "server": {
                if (!player.hasPermission("buildmc.admin")) {
                    CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.error.no-permission"));
                    return 0;
                }
                for (long id : ClaimManager.serverClaims) {
                    if (!name.equalsIgnoreCase(ClaimManager.getClaimNameById(id))) continue;
                    claim = ClaimManager.getClaimByID(id);
                    claimId = id;
                    break block5;
                }
                break;
            }
            default: {
                CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.protections.invalid-type"));
                return 0;
            }
        }
        if (claim == null || claimId == -1L) {
            CoreMain.pluginMain.sendMessage((CommandSender)player, Component.translatable("messages.claims.remove.not-found"));
            return 0;
        }
        Protection protection = Objects.requireNonNull(CoreMain.protectionsRegistry.get(flag));
        ClaimProtectionChangeEvent event = new ClaimProtectionChangeEvent(claim, protection, value ? ClaimProtectionChangeEvent.ActiveState.ENABLED : ClaimProtectionChangeEvent.ActiveState.DISABLED, (CommandSender)player);
        if (event.isCancelled()) {
            return 0;
        }
        if (value) {
            ClaimManager.addProtection(claimId, flag);
            CoreMain.pluginMain.sendMessage((CommandSender)player, Message.msg(player, "messages.claims.protections.added", Map.of("flag", flag.toString())));
            ClaimLogger.logProtectionChanged(player, name, flag.toString(), "enabled");
        } else {
            ClaimManager.removeProtection(claimId, flag);
            CoreMain.pluginMain.sendMessage((CommandSender)player, Message.msg(player, "messages.claims.protections.removed", Map.of("flag", flag.toString())));
            ClaimLogger.logProtectionChanged(player, name, flag.toString(), "disabled");
        }
        return 1;
    }
}

