/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.database.DatabaseConfig;
import net.mathias2246.buildmc.database.DatabaseTable;
import net.mathias2246.buildmc.database.SchemaVersionTable;
import net.mathias2246.buildmc.database.migrations.Migration;
import net.mathias2246.buildmc.database.migrations.MigrationV1;
import org.bukkit.plugin.Plugin;
import org.h2.tools.Server;

public class DatabaseManager {
    private final DatabaseConfig config;
    private Connection connection;
    private final Logger logger;
    private final File databaseFolder;
    private final List<DatabaseTable> registeredTables = new ArrayList<DatabaseTable>();
    private final List<Migration> migrations = List.of(new MigrationV1());
    private Server tcpServer;

    public DatabaseManager(Plugin plugin) {
        this.config = CoreMain.databaseConfig;
        this.logger = plugin.getLogger();
        this.databaseFolder = new File(plugin.getDataFolder(), "Data");
        if (!this.databaseFolder.exists()) {
            if (this.databaseFolder.mkdirs()) {
                this.logger.info("Created database directory: " + this.databaseFolder.getAbsolutePath());
            } else {
                this.logger.severe("Failed to create database directory!");
            }
        }
        this.config.reloadConfig();
    }

    public void connect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.logger.warning("Error closing old database connection: " + String.valueOf(e));
        }
        if (this.config.isServerMode()) {
            try {
                if (this.tcpServer == null || !this.tcpServer.isRunning(true)) {
                    this.logger.info("Starting internal H2 TCP server...");
                    this.tcpServer = Server.createTcpServer("-tcp", "-tcpAllowOthers", "-tcpPort", String.valueOf(this.config.getServerPort()), "-baseDir", this.databaseFolder.getAbsolutePath()).start();
                    this.logger.info("H2 TCP server started at: " + this.tcpServer.getURL());
                } else {
                    this.logger.info("H2 TCP server is already running.");
                }
            }
            catch (SQLException e) {
                this.logger.severe("Failed to start H2 TCP server: " + String.valueOf(e));
                return;
            }
        }
        String databaseFilePath = new File(this.databaseFolder, "database").getAbsolutePath();
        Object url = this.config.isServerMode() ? this.config.getServerUrl() : "jdbc:h2:file:" + databaseFilePath;
        try {
            Class.forName("org.h2.Driver");
            this.connection = DriverManager.getConnection((String)url, "sa", "");
        }
        catch (ClassNotFoundException | SQLException e) {
            this.logger.severe("Database connection failed: " + String.valueOf(e));
        }
        this.runMigrations();
    }

    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connect();
            }
        }
        catch (SQLException e) {
            this.logger.severe("Failed to check or re-establish database connection: " + String.valueOf(e));
        }
        return this.connection;
    }

    public void runMigrations() {
        try {
            SchemaVersionTable versionTable = new SchemaVersionTable();
            versionTable.createTable(this.getConnection());
            int currentVersion = versionTable.getCurrentVersion(this.getConnection());
            for (Migration migration : this.migrations) {
                if (migration.getTargetVersion() <= currentVersion) continue;
                this.logger.info("Applying database migration to version " + migration.getTargetVersion());
                migration.migrate(this.getConnection());
                versionTable.updateVersion(this.getConnection(), migration.getTargetVersion());
                this.logger.info("Database migration to version " + migration.getTargetVersion() + " applied.");
            }
        }
        catch (SQLException e) {
            this.logger.severe("Migration failed: " + String.valueOf(e));
            throw new RuntimeException("Database migration failed", e);
        }
    }

    public void registerTable(DatabaseTable table) {
        this.registeredTables.add(table);
        try {
            table.createTable(this.getConnection());
        }
        catch (SQLException e) {
            this.logger.severe("Failed to create table: " + table.getClass().getSimpleName() + " - " + String.valueOf(e));
        }
    }

    public List<DatabaseTable> getRegisteredTables() {
        return this.registeredTables;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.logger.info("Database connection closed.");
            }
            catch (SQLException e) {
                this.logger.severe("Error closing database connection: " + String.valueOf(e));
            }
        }
        if (this.tcpServer != null && this.tcpServer.isRunning(true)) {
            this.logger.info("Stopping internal H2 TCP server...");
            this.tcpServer.stop();
            this.tcpServer = null;
            this.logger.info("H2 TCP server stopped.");
        }
    }
}

