/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.inventoryframework.nms.v1_16_1;

import java.util.ArrayList;
import java.util.List;
import net.mathias2246.buildmc.inventoryframework.abstraction.BeaconInventory;
import net.minecraft.server.v1_16_R1.BlockPosition;
import net.minecraft.server.v1_16_R1.ChatComponentText;
import net.minecraft.server.v1_16_R1.Container;
import net.minecraft.server.v1_16_R1.ContainerAccess;
import net.minecraft.server.v1_16_R1.ContainerBeacon;
import net.minecraft.server.v1_16_R1.ContainerProperties;
import net.minecraft.server.v1_16_R1.EntityHuman;
import net.minecraft.server.v1_16_R1.IChatBaseComponent;
import net.minecraft.server.v1_16_R1.IContainerProperties;
import net.minecraft.server.v1_16_R1.IInventory;
import net.minecraft.server.v1_16_R1.ItemStack;
import net.minecraft.server.v1_16_R1.NonNullList;
import net.minecraft.server.v1_16_R1.PlayerInventory;
import net.minecraft.server.v1_16_R1.Slot;
import net.minecraft.server.v1_16_R1.TileEntityContainer;
import net.minecraft.server.v1_16_R1.TileEntityTypes;
import net.minecraft.server.v1_16_R1.World;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeaconInventoryImpl
extends BeaconInventory {
    @Override
    @NotNull
    public Inventory createInventory() {
        InventoryViewProvider container = new InventoryViewProvider(){

            protected Container createContainer(int containerId, PlayerInventory playerInventory) {
                return new ContainerBeaconImpl(containerId, playerInventory.player, (IInventory)this);
            }

            @NotNull
            @Contract(pure=true)
            protected IChatBaseComponent getContainerName() {
                return new ChatComponentText("Beacon");
            }
        };
        return new CraftInventoryBeacon((IInventory)container, (IInventory)container){
            final /* synthetic */ IInventory val$container;
            {
                this.val$container = iInventory;
                super(beacon);
            }

            @NotNull
            @Contract(pure=true)
            public InventoryType getType() {
                return InventoryType.BEACON;
            }

            public IInventory getInventory() {
                return this.val$container;
            }
        };
    }

    private static class ContainerBeaconImpl
    extends ContainerBeacon {
        @NotNull
        private final EntityHuman player;
        @NotNull
        private final IInventory inputSlot;
        @Nullable
        private CraftInventoryView bukkitEntity;

        public ContainerBeaconImpl(int containerId, @NotNull EntityHuman player, @NotNull IInventory inputSlot) {
            super(containerId, (IInventory)player.inventory, (IContainerProperties)new ContainerProperties(3), ContainerAccess.at((World)player.world, (BlockPosition)BlockPosition.ZERO));
            this.player = player;
            this.inputSlot = inputSlot;
            this.checkReachable = false;
            Slot slot = (Slot)this.slots.get(0);
            Slot newSlot = new Slot(inputSlot, slot.index, slot.e, slot.f);
            newSlot.rawSlotIndex = slot.rawSlotIndex;
            this.slots.set(0, newSlot);
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity != null) {
                return this.bukkitEntity;
            }
            CraftInventoryBeacon inventory = new CraftInventoryBeacon(this.inputSlot);
            this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player.getBukkitEntity(), (Inventory)inventory, (Container)this);
            return this.bukkitEntity;
        }

        public void b(@Nullable EntityHuman player) {
        }
    }

    private static abstract class InventoryViewProvider
    extends TileEntityContainer {
        private final int size = 1;
        public ItemStack item = ItemStack.b;
        public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
        private int maxStack = 1;

        protected InventoryViewProvider() {
            super(TileEntityTypes.BEACON);
        }

        public void clear() {
            this.item = ItemStack.b;
            this.update();
        }

        public int getSize() {
            return 1;
        }

        public boolean isEmpty() {
            return this.item.isEmpty();
        }

        public ItemStack getItem(int index) {
            return index == 0 ? this.item : ItemStack.b;
        }

        public ItemStack splitStack(int firstIndex, int secondIndex) {
            ItemStack itemstack;
            ItemStack itemStack = itemstack = firstIndex == 0 && !this.item.isEmpty() && secondIndex > 0 ? this.item.cloneAndSubtract(secondIndex) : ItemStack.b;
            if (!itemstack.isEmpty()) {
                this.update();
            }
            return itemstack;
        }

        public ItemStack splitWithoutUpdate(int index) {
            ItemStack itemstack = this.getItem(index);
            if (itemstack.isEmpty()) {
                return ItemStack.b;
            }
            this.item = ItemStack.b;
            return itemstack;
        }

        public void setItem(int index, ItemStack itemStack) {
            this.item = itemStack;
            if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
                itemStack.setCount(this.getMaxStackSize());
            }
            this.update();
        }

        public int getMaxStackSize() {
            return this.maxStack;
        }

        public boolean a(EntityHuman entityHuman) {
            return true;
        }

        public List<ItemStack> getContents() {
            return NonNullList.a((Object)this.item, (Object[])new ItemStack[0]);
        }

        public void onOpen(CraftHumanEntity craftHumanEntity) {
            this.transaction.add((HumanEntity)craftHumanEntity);
        }

        public void onClose(CraftHumanEntity craftHumanEntity) {
            this.transaction.remove(craftHumanEntity);
        }

        public List<HumanEntity> getViewers() {
            return this.transaction;
        }

        public void setMaxStackSize(int maxStack) {
            this.maxStack = maxStack;
        }
    }
}

