/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.inventoryframework.nms.v1_17_0;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.mathias2246.buildmc.inventoryframework.abstraction.AnvilInventory;
import net.mathias2246.buildmc.inventoryframework.adventuresupport.TextHolder;
import net.mathias2246.buildmc.inventoryframework.nms.v1_17_0.util.TextHolderUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilInventoryImpl
extends AnvilInventory {
    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory(final @NotNull TextHolder title) {
        final InventorySubcontainer inputSlots = new InventorySubcontainer(2);
        final InventorySubcontainer resultSlot = new InventorySubcontainer(1);
        return new CraftInventoryAnvil(null, (IInventory)inputSlots, (IInventory)resultSlot, null){

            @NotNull
            @Contract(pure=true)
            public InventoryType getType() {
                return InventoryType.ANVIL;
            }

            public IInventory getInventory() {
                return new InventoryViewProvider(){

                    @NotNull
                    @Contract(pure=true)
                    public Container createMenu(int containerId, @Nullable PlayerInventory inventory, @NotNull EntityHuman player) {
                        return new ContainerAnvilImpl(containerId, player, inputSlots, resultSlot);
                    }

                    @NotNull
                    @Contract(pure=true)
                    public IChatBaseComponent getScoreboardDisplayName() {
                        return TextHolderUtil.toComponent(title);
                    }
                };
            }
        };
    }

    private class ContainerAnvilImpl
    extends ContainerAnvil {
        @NotNull
        private final InventorySubcontainer inputSlots;
        @NotNull
        private final InventorySubcontainer resultSlot;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Method updateTrackedSlotMethod;
        @NotNull
        private final Field propertiesField;
        @NotNull
        private final Field listenersField;

        public ContainerAnvilImpl(@NotNull int containerId, @NotNull EntityHuman player, @NotNull InventorySubcontainer inputSlots, InventorySubcontainer resultSlot) {
            super(containerId, player.getInventory(), ContainerAccess.at((World)player.t, (BlockPosition)BlockPosition.b));
            this.inputSlots = inputSlots;
            this.resultSlot = resultSlot;
            this.checkReachable = false;
            this.w.set((int)AnvilInventoryImpl.this.cost);
            InventoryLargeChest compoundContainer = new InventoryLargeChest((IInventory)inputSlots, (IInventory)resultSlot);
            this.updateSlot(0, (IInventory)compoundContainer);
            this.updateSlot(1, (IInventory)compoundContainer);
            this.updateSlot(2, (IInventory)compoundContainer);
            try {
                this.updateTrackedSlotMethod = Container.class.getDeclaredMethod("a", Integer.TYPE, ItemStack.class, Supplier.class);
                this.updateTrackedSlotMethod.setAccessible(true);
                this.propertiesField = Container.class.getDeclaredField("l");
                this.propertiesField.setAccessible(true);
                this.listenersField = Container.class.getDeclaredField("u");
                this.listenersField.setAccessible(true);
            }
            catch (NoSuchFieldException | NoSuchMethodException exception) {
                throw new IllegalStateException(exception);
            }
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity != null) {
                return this.bukkitEntity;
            }
            CraftInventoryAnvil inventory = new CraftInventoryAnvil(this.q.getLocation(), (IInventory)this.inputSlots, (IInventory)this.resultSlot, (ContainerAnvil)this);
            this.bukkitEntity = new CraftInventoryView((HumanEntity)this.r.getBukkitEntity(), (Inventory)inventory, (Container)this);
            return this.bukkitEntity;
        }

        public void d() {
            if (this.w.c()) {
                this.broadcastFullState();
            } else {
                for (int index = 0; index < this.i.size(); ++index) {
                    if (ItemStack.matches((ItemStack)((ItemStack)this.n.get(index)), (ItemStack)((Slot)this.i.get(index)).getItem())) continue;
                    this.broadcastFullState();
                    return;
                }
            }
        }

        public void a(@Nullable String name) {
            String string = name = name == null ? "" : name;
            if (!name.equals(AnvilInventoryImpl.this.observableText.get())) {
                AnvilInventoryImpl.this.observableText.set(name);
            }
            this.broadcastFullState();
        }

        public void a(@NotNull IInventory container) {
            this.d();
        }

        public void a(int index, int dragData, @NotNull InventoryClickType clickType, @NotNull EntityHuman player) {
            super.a(index, dragData, clickType, player);
            this.broadcastFullState();
        }

        public void i() {
        }

        public void b(@NotNull EntityHuman nmsPlayer) {
        }

        protected void a(@NotNull EntityHuman player, @NotNull IInventory inventory) {
        }

        protected void a(@NotNull EntityHuman player, @NotNull ItemStack stack) {
        }

        private void broadcastFullState() {
            List properties;
            for (int index = 0; index < this.i.size(); ++index) {
                ItemStack itemstack = ((Slot)this.i.get(index)).getItem();
                Objects.requireNonNull(itemstack);
                Supplier<ItemStack> supplier = () -> ((ItemStack)itemstack).cloneItemStack();
                try {
                    this.updateTrackedSlotMethod.invoke((Object)this, index, itemstack, supplier);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException exception) {
                    throw new IllegalStateException(exception);
                }
            }
            try {
                properties = (List)this.propertiesField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException(exception);
            }
            for (int index = 0; index < properties.size(); ++index) {
                ContainerProperty property = (ContainerProperty)properties.get(index);
                if (!property.c()) continue;
                try {
                    for (ICrafting listener : (List)this.listenersField.get((Object)this)) {
                        listener.setContainerData((Container)this, index, property.get());
                    }
                    continue;
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException(exception);
                }
            }
            this.updateInventory();
        }

        private void updateSlot(int slotIndex, @NotNull IInventory container) {
            Slot slot = (Slot)this.i.get(slotIndex);
            Slot newSlot = new Slot(container, slot.a, slot.e, slot.f);
            newSlot.d = slot.d;
            this.i.set(slotIndex, (Object)newSlot);
        }
    }

    private static abstract class InventoryViewProvider
    extends InventorySubcontainer
    implements ITileInventory {
        private InventoryViewProvider() {
            super(new ItemStack[0]);
        }
    }
}

