/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.player.status;

import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.event.player.StatusChangeEvent;
import net.mathias2246.buildmc.api.status.StatusInstance;
import net.mathias2246.buildmc.api.status.StatusManager;
import net.mathias2246.buildmc.status.PlayerStatusUtil;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerStatus
implements Listener,
StatusManager {
    @Override
    public void setPlayerStatus(@NotNull Player player, String status, boolean join) {
        PlayerStatusUtil.setPlayerStatus(player, status, join);
    }

    @Override
    public void setPlayerName(@NotNull Player player, @Nullable Component component) {
        player.playerListName(component);
        player.displayName(component);
        player.customName(component);
        player.setCustomNameVisible(true);
    }

    @Override
    public void resetPlayerName(@NotNull Player player) {
        player.playerListName(null);
        player.displayName(null);
        player.customName(null);
        player.setCustomNameVisible(true);
    }

    @Override
    public boolean removePlayerStatus(@NotNull Player player) {
        @Nullable StatusInstance old = (StatusInstance)CoreMain.statusesRegistry.get(Objects.requireNonNull(NamespacedKey.fromString((String)("buildmc:" + (String)player.getPersistentDataContainer().get(PlayerStatusUtil.PLAYER_STATUS_PDC, PersistentDataType.STRING)))).key());
        StatusChangeEvent e = new StatusChangeEvent(player, old, null);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return false;
        }
        this.forceRemovePlayerStatus(player);
        return true;
    }

    @Override
    public void forceRemovePlayerStatus(@NotNull Player player) {
        player.getPersistentDataContainer().remove(PlayerStatusUtil.PLAYER_STATUS_PDC);
        player.playerListName(null);
        player.displayName(null);
        player.customName(null);
        player.setCustomNameVisible(false);
    }
}

