/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.player.status;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.text.Component;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.Main;
import net.mathias2246.buildmc.commands.CommandUtil;
import net.mathias2246.buildmc.commands.CustomCommand;
import net.mathias2246.buildmc.status.StatusConfig;
import net.mathias2246.buildmc.util.SoundUtil;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public record SetStatusCommand(@NotNull StatusConfig config) implements CustomCommand
{
    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        LiteralArgumentBuilder cmd = Commands.literal((String)"status");
        cmd.executes(command -> {
            ((CommandSourceStack)command.getSource()).getSender().sendMessage("/status <args>");
            return 1;
        });
        cmd.requires(command -> Main.config.getBoolean("status.enabled", true));
        LiteralArgumentBuilder removeSub = Commands.literal((String)"remove");
        removeSub.executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer(((CommandSourceStack)command.getSource()).getSender());
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            CoreMain.statusManager.removePlayerStatus(player);
            player.sendMessage((Component)Component.translatable("messages.status.successfully-removed"));
            CoreMain.soundManager.playSound(player, SoundUtil.success);
            return 1;
        });
        LiteralArgumentBuilder setSub = (LiteralArgumentBuilder)Commands.literal((String)"set").executes(command -> {
            CommandSender patt0$temp = ((CommandSourceStack)command.getSource()).getSender();
            if (!(patt0$temp instanceof Player)) {
                ((CommandSourceStack)command.getSource()).getSender().sendMessage((Component)Component.translatable("messages.status.only-players"));
                return 0;
            }
            Player player = (Player)patt0$temp;
            return 1;
        });
        RequiredArgumentBuilder setSubArg = (RequiredArgumentBuilder)Commands.argument((String)"status_id", (ArgumentType)StringArgumentType.string()).executes(command -> {
            Player patt0$temp = CommandUtil.requiresPlayer(((CommandSourceStack)command.getSource()).getSender());
            if (!(patt0$temp instanceof Player)) {
                return 0;
            }
            Player player = patt0$temp;
            CoreMain.statusManager.setPlayerStatus(player, (String)command.getArgument("status_id", String.class), false);
            return 1;
        });
        setSubArg.suggests((ctx, builder) -> {
            String remaining = builder.getRemaining().toLowerCase();
            for (NamespacedKey si : CoreMain.statusesRegistry.keySet()) {
                String statusId = si.toString().replace("buildmc:", "");
                if (!statusId.toLowerCase().startsWith(remaining)) continue;
                builder.suggest(statusId);
            }
            return builder.buildFuture();
        });
        setSub.then((ArgumentBuilder)setSubArg);
        cmd.then((ArgumentBuilder)removeSub);
        cmd.then((ArgumentBuilder)setSub);
        return cmd.build();
    }
}

