/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.ui.claims;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.mathias2246.buildmc.CoreMain;
import net.mathias2246.buildmc.api.claims.Claim;
import net.mathias2246.buildmc.api.claims.ClaimType;
import net.mathias2246.buildmc.claims.ClaimManager;
import net.mathias2246.buildmc.inventoryframework.adventuresupport.ComponentHolder;
import net.mathias2246.buildmc.inventoryframework.gui.GuiItem;
import net.mathias2246.buildmc.inventoryframework.gui.type.ChestGui;
import net.mathias2246.buildmc.inventoryframework.pane.OutlinePane;
import net.mathias2246.buildmc.inventoryframework.pane.PaginatedPane;
import net.mathias2246.buildmc.inventoryframework.pane.Pane;
import net.mathias2246.buildmc.inventoryframework.pane.StaticPane;
import net.mathias2246.buildmc.ui.UIUtil;
import net.mathias2246.buildmc.ui.claims.ClaimEditMenu;
import net.mathias2246.buildmc.util.Message;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ClaimSelectMenu {
    private static final LegacyComponentSerializer LEGACY = LegacyComponentSerializer.legacySection();

    public static void open(Player player) {
        Claim c;
        long id;
        List playerClaimIds = ClaimManager.playerOwner.getOrDefault(player.getUniqueId(), Collections.emptyList());
        HashSet<Long> playerClaimIdSet = new HashSet<Long>(playerClaimIds);
        List teamClaimIds = Optional.ofNullable(ClaimManager.getPlayerTeam(player)).map(t -> ClaimManager.teamOwner.getOrDefault(t.getName(), Collections.emptyList())).orElse(Collections.emptyList());
        ArrayList<Claim> claims = new ArrayList<Claim>();
        Iterator<Object> iterator = playerClaimIds.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            c = ClaimManager.getClaimByID(id);
            if (c == null) continue;
            claims.add(c);
        }
        iterator = teamClaimIds.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            c = ClaimManager.getClaimByID(id);
            if (c == null) continue;
            claims.add(c);
        }
        if (player.hasPermission("buildmc.admin")) {
            iterator = ClaimManager.serverClaims.iterator();
            while (iterator.hasNext()) {
                id = (Long)iterator.next();
                c = ClaimManager.getClaimByID(id);
                if (c == null) continue;
                claims.add(c);
            }
            iterator = ClaimManager.placeholderClaims.iterator();
            while (iterator.hasNext()) {
                id = (Long)iterator.next();
                c = ClaimManager.getClaimByID(id);
                if (c == null) continue;
                claims.add(c);
            }
        }
        ChestGui gui = new ChestGui(6, ComponentHolder.of(Component.translatable("messages.claims.ui.select-menu.title")));
        StaticPane background = new StaticPane(0, 0, 9, 5);
        background.setPriority(Pane.Priority.LOW);
        ItemStack filler = ClaimSelectMenu.createFiller(player);
        background.fillWith(filler, e -> e.setCancelled(true));
        gui.addPane(background);
        PaginatedPane pages = new PaginatedPane(0, 0, 9, 5);
        List<GuiItem> items = ClaimSelectMenu.buildClaimItems(player, claims, playerClaimIdSet);
        if (items.isEmpty()) {
            OutlinePane placeholder = new OutlinePane(0, 0, 9, 5);
            placeholder.addItem(new GuiItem(ClaimSelectMenu.makeInfoPaper(player, Message.msg(player, "messages.claims.ui.select-menu.empty")), e -> e.setCancelled(true)));
            pages.addPane(0, placeholder);
        } else {
            int itemsPerPage = 45;
            int totalPages = (int)Math.ceil((double)items.size() / 45.0);
            for (int page = 0; page < totalPages; ++page) {
                int start = page * 45;
                int end = Math.min(start + 45, items.size());
                OutlinePane pagePane = new OutlinePane(0, 0, 9, 5);
                pagePane.setPriority(Pane.Priority.NORMAL);
                items.subList(start, end).forEach(pagePane::addItem);
                pages.addPane(page, pagePane);
            }
        }
        gui.addPane(pages);
        StaticPane controls = UIUtil.BOTTOM_BAR.copy();
        controls.setPriority(Pane.Priority.HIGHEST);
        ClaimSelectMenu.updatePageIndicator(player, controls, 0, Math.max(1, pages.getPages()), pages, gui);
        gui.addPane(controls);
        gui.show((HumanEntity)player);
    }

    private static List<GuiItem> buildClaimItems(Player player, List<Claim> claims, Set<Long> playerClaimIds) {
        ArrayList<GuiItem> items = new ArrayList<GuiItem>();
        for (Claim claim : claims) {
            ItemStack item = new ItemStack(switch (claim.getType()) {
                case ClaimType.PLAYER -> Material.PLAYER_HEAD;
                case ClaimType.TEAM -> Material.IRON_SWORD;
                case ClaimType.SERVER -> Material.COMMAND_BLOCK;
                case ClaimType.PLACEHOLDER -> Material.STRUCTURE_VOID;
                default -> Material.PAPER;
            });
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.claims.ui.errors.no-item-meta"));
                continue;
            }
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setDisplayName(LEGACY.serialize(Component.text(claim.getName(), (TextColor)NamedTextColor.GREEN)));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(switch (claim.getType()) {
                case ClaimType.PLAYER -> LEGACY.serialize(Message.msg(player, "messages.claims.ui.select-menu.player-type"));
                case ClaimType.TEAM -> LEGACY.serialize(Message.msg(player, "messages.claims.ui.select-menu.team-type"));
                case ClaimType.SERVER -> LEGACY.serialize(Message.msg(player, "messages.claims.ui.select-menu.server-type"));
                case ClaimType.PLACEHOLDER -> LEGACY.serialize(Message.msg(player, "messages.claims.ui.select-menu.placeholder-type"));
                default -> LEGACY.serialize(Message.msg(player, "messages.claims.ui.select-menu.unknown-type"));
            });
            lore.add(LEGACY.serialize(Message.msg(player, "messages.claims.ui.select-menu.id", Map.of("id", String.valueOf(claim.getId())))));
            meta.setLore(lore);
            item.setItemMeta(meta);
            items.add(new GuiItem(item, event -> {
                event.setCancelled(true);
                CoreMain.soundManager.playSound(player, UIUtil.CLICK_SOUND);
                ClaimEditMenu.open(player, claim);
            }));
        }
        return items;
    }

    private static void updatePageIndicator(Player player, StaticPane controls, int currentPage, int totalPages, PaginatedPane pages, ChestGui gui) {
        controls.removeItem(2, 0);
        controls.removeItem(4, 0);
        controls.removeItem(6, 0);
        ItemStack indicator = ClaimSelectMenu.makePageIndicator(player, currentPage + 1, totalPages);
        controls.addItem(new GuiItem(indicator, e -> e.setCancelled(true)), 4, 0);
        if (currentPage > 0) {
            ItemStack prev = ClaimSelectMenu.createNavItem(player, "messages.claims.ui.general.previous");
            controls.addItem(new GuiItem(prev, e -> {
                e.setCancelled(true);
                CoreMain.soundManager.playSound(player, UIUtil.CLICK_SOUND);
                if (pages.getPage() > 0) {
                    pages.setPage(pages.getPage() - 1);
                    ClaimSelectMenu.updatePageIndicator(player, controls, pages.getPage(), totalPages, pages, gui);
                    gui.update();
                }
            }), 2, 0);
        } else {
            controls.addItem(new GuiItem(ClaimSelectMenu.createDisabledNavItem(player), UIUtil.noInteract), 2, 0);
        }
        if (currentPage < totalPages - 1) {
            ItemStack next = ClaimSelectMenu.createNavItem(player, "messages.claims.ui.general.next");
            controls.addItem(new GuiItem(next, e -> {
                e.setCancelled(true);
                CoreMain.soundManager.playSound(player, UIUtil.CLICK_SOUND);
                if (pages.getPage() < pages.getPages() - 1) {
                    pages.setPage(pages.getPage() + 1);
                    ClaimSelectMenu.updatePageIndicator(player, controls, pages.getPage(), totalPages, pages, gui);
                    gui.update();
                }
            }), 6, 0);
        } else {
            controls.addItem(new GuiItem(ClaimSelectMenu.createDisabledNavItem(player), UIUtil.noInteract), 6, 0);
        }
    }

    private static ItemStack createDisabledNavItem(Player player) {
        ItemStack item = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setItemName(null);
            meta.setHideTooltip(true);
            item.setItemMeta(meta);
        }
        return item;
    }

    private static ItemStack makeInfoPaper(Player player, Component line) {
        ItemStack item = new ItemStack(Material.PAPER);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.claims.ui.errors.no-item-meta"));
            return item;
        }
        meta.setDisplayName(LEGACY.serialize(line));
        item.setItemMeta(meta);
        return item;
    }

    private static ItemStack createFiller(Player player) {
        ItemStack filler = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = filler.getItemMeta();
        if (meta == null) {
            CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.claims.ui.errors.no-item-meta"));
            return filler;
        }
        meta.setHideTooltip(true);
        filler.setItemMeta(meta);
        return filler;
    }

    private static ItemStack createNavItem(Player player, String messageKey) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.claims.ui.errors.no-item-meta"));
            return item;
        }
        meta.setDisplayName(LEGACY.serialize(Message.msg(player, messageKey)));
        item.setItemMeta(meta);
        return item;
    }

    private static ItemStack makePageIndicator(Player player, int current, int total) {
        ItemStack item = new ItemStack(Material.PAPER);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            CoreMain.mainClass.sendMessage((CommandSender)player, Component.translatable("messages.claims.ui.errors.no-item-meta"));
            return item;
        }
        meta.setDisplayName(LEGACY.serialize(Message.msg(player, "messages.claims.ui.general.page-indicator", Map.of("current", String.valueOf(current), "total", String.valueOf(total)))));
        item.setItemMeta(meta);
        return item;
    }
}

