/*
 * Decompiled with CFR 0.152.
 */
package net.mathias2246.buildmc.util;

import net.mathias2246.buildmc.CoreMain;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class ParticleSpawner {
    private int repeatTimes;
    public final int delay;
    @NotNull
    protected final Player source;

    public ParticleSpawner(int repeatTimes, int delay, @NotNull Player source) {
        this.repeatTimes = repeatTimes;
        this.delay = delay;
        this.source = source;
        this.buildParticleSpawner();
    }

    public abstract void buildParticleSpawner();

    protected abstract boolean shouldStop();

    protected abstract void display();

    protected abstract void onStop();

    public void run() {
        this.source.getScheduler().runAtFixedRate(CoreMain.plugin, scheduledTask -> {
            if (this.repeatTimes < 0 || this.shouldStop()) {
                this.onStop();
                scheduledTask.cancel();
            }
            this.display();
            --this.repeatTimes;
        }, null, 1L, (long)this.delay);
    }

    @FunctionalInterface
    public static interface Builder<T extends ParticleSpawner> {
        public T build(@NotNull Player var1);
    }
}

