/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.guihandler.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.guihandler.GuiHandler;
import org.lushplugins.guihandler.gui.ActionCallable;
import org.lushplugins.guihandler.gui.GuiAction;
import org.lushplugins.guihandler.gui.GuiActor;
import org.lushplugins.guihandler.gui.GuiContext;
import org.lushplugins.guihandler.gui.GuiLayer;
import org.lushplugins.guihandler.libraries.chatcolorhandler.ModernChatColorHandler;
import org.lushplugins.guihandler.slot.Button;
import org.lushplugins.guihandler.slot.IconProvider;
import org.lushplugins.guihandler.slot.LabelledSlotProvider;
import org.lushplugins.guihandler.slot.Slot;
import org.lushplugins.guihandler.slot.SlotProvider;

public class Gui {
    private final GuiHandler instance;
    private final Inventory inventory;
    private final Slot[] slots;
    private final GuiActor actor;
    private final boolean locked;
    private final Map<Character, LabelledSlotProvider> labelProviders;
    private final Multimap<GuiAction, ActionCallable> actions;
    private final Map<Class<?>, Object> provided;
    private int page = 1;

    private Gui(GuiHandler instance, GuiActor actor, Inventory inventory, Slot[] slots, boolean locked, Map<Character, LabelledSlotProvider> labelProviders, Multimap<GuiAction, ActionCallable> actions, Map<Class<?>, Object> provided) {
        this.instance = instance;
        this.actor = actor;
        this.inventory = inventory;
        this.slots = slots;
        this.locked = locked;
        this.labelProviders = labelProviders;
        this.actions = actions;
        this.provided = provided;
        this.refreshLabelIndexes();
        this.open();
    }

    public GuiHandler instance() {
        return this.instance;
    }

    public Inventory inventory() {
        return this.inventory;
    }

    public GuiActor actor() {
        return this.actor;
    }

    public Slot[] slots() {
        return Arrays.copyOf(this.slots, this.slots.length);
    }

    public Slot slot(int slot) {
        return this.slots[slot];
    }

    @Nullable
    public <T> T provided(Class<T> typeClass) {
        Object providedObject = this.provided.get(typeClass);
        return (T)(providedObject != null ? providedObject : null);
    }

    private void refreshLabelIndexes() {
        HashMap<Character, AtomicInteger> indexes = new HashMap<Character, AtomicInteger>();
        for (Slot slot : this.slots) {
            char label = slot.label();
            int index = indexes.computeIfAbsent(Character.valueOf(label), ignored -> new AtomicInteger()).getAndIncrement();
            slot.labelIndex(index);
        }
    }

    @Nullable
    public LabelledSlotProvider getProviderFor(char label) {
        return this.labelProviders.get(Character.valueOf(label));
    }

    public void setProviderFor(char label, LabelledSlotProvider provider) {
        this.labelProviders.put(Character.valueOf(label), provider);
    }

    public void applyLayer(GuiLayer layer) {
        TreeMultimap<Character, Integer> slotMap = layer.getSlotMap();
        Iterator iterator = slotMap.keySet().iterator();
        while (iterator.hasNext()) {
            char label = ((Character)iterator.next()).charValue();
            SlotProvider provider = Optional.ofNullable(layer.getSlotProvider(label)).orElseGet(() -> this.instance.getDefaultProvider(label));
            if (provider == null) continue;
            Iterator iterator2 = slotMap.get((Object)Character.valueOf(label)).iterator();
            while (iterator2.hasNext()) {
                int rawSlot = (Integer)iterator2.next();
                Slot slot = this.slot(rawSlot);
                slot.label(label);
                slot.slotProvider(provider);
            }
        }
        this.refreshLabelIndexes();
    }

    public int page() {
        return this.page;
    }

    public void page(int page) {
        if (this.page != page) {
            this.page = page;
            this.refresh();
        }
    }

    public void nextPage() {
        this.page(this.page + 1);
    }

    public void previousPage() {
        this.page(this.page - 1);
    }

    protected void open() {
        this.refresh();
        Player player = this.actor.player();
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)this.instance.getPlugin(), () -> player.openInventory(this.inventory));
        } else {
            player.openInventory(this.inventory);
        }
        this.instance.setOpenGui(player.getUniqueId(), this);
        this.callAction(GuiAction.CLOSE);
    }

    public void refresh(Slot slot) {
        this.inventory.setItem(slot.rawSlot(), slot.icon(this));
    }

    public void refresh() {
        this.callAction(GuiAction.REFRESH);
        Arrays.stream(this.slots).collect(Collectors.groupingBy(Slot::label)).forEach((label, slots) -> {
            LabelledSlotProvider provider = this.labelProviders.get(label);
            if (provider != null) {
                provider.apply(this, label.charValue(), (List<Slot>)slots);
            }
        });
        for (Slot slot : this.slots) {
            this.refresh(slot);
        }
        this.callAction(GuiAction.POST_REFRESH);
    }

    public void onClick(InventoryClickEvent event) {
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        int rawSlot = event.getRawSlot();
        if (rawSlot <= this.slots.length) {
            try {
                Slot slot = this.slot(rawSlot);
                slot.click(event, this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.locked) {
            event.setCancelled(true);
            return;
        }
        switch (event.getAction()) {
            case COLLECT_TO_CURSOR: {
                event.setCancelled(true);
                break;
            }
            case DROP_ALL_SLOT: 
            case DROP_ONE_SLOT: 
            case PLACE_ALL: 
            case PLACE_SOME: 
            case PLACE_ONE: 
            case PICKUP_ALL: 
            case PICKUP_HALF: 
            case PICKUP_SOME: 
            case PICKUP_ONE: 
            case SWAP_WITH_CURSOR: 
            case CLONE_STACK: 
            case HOTBAR_SWAP: 
            case HOTBAR_MOVE_AND_READD: {
                if (!clickedInventory.equals((Object)this.inventory) || !this.slots[rawSlot].locked()) break;
                event.setCancelled(true);
                break;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                event.setCancelled(true);
                if (clickedInventory.equals((Object)this.inventory)) break;
                ItemStack clickedItem = event.getCurrentItem();
                if (clickedItem == null) {
                    return;
                }
                List<Integer> unlockedSlots = Arrays.stream(this.slots).filter(aSlot -> !aSlot.locked()).map(Slot::rawSlot).sorted().toList();
                int remainingToDistribute = clickedItem.getAmount();
                int backupDestinationSlot = -1;
                boolean complete = false;
                for (int unlockedSlot : unlockedSlots) {
                    if (complete) break;
                    ItemStack slotItem = this.inventory.getItem(unlockedSlot);
                    if (backupDestinationSlot == -1 && (slotItem == null || slotItem.getType() == Material.AIR)) {
                        backupDestinationSlot = unlockedSlot;
                        continue;
                    }
                    if (slotItem == null || !slotItem.isSimilar(clickedItem)) continue;
                    int spaceInStack = slotItem.getMaxStackSize() - slotItem.getAmount();
                    if (spaceInStack <= remainingToDistribute) {
                        slotItem.setAmount(slotItem.getAmount() + remainingToDistribute);
                        event.setCurrentItem(null);
                        complete = true;
                        continue;
                    }
                    if (spaceInStack <= 0) continue;
                    remainingToDistribute -= spaceInStack;
                    slotItem.setAmount(slotItem.getMaxStackSize());
                    clickedItem.setAmount(clickedItem.getAmount() - spaceInStack);
                }
                if (complete || backupDestinationSlot == -1) break;
                this.inventory.setItem(backupDestinationSlot, clickedItem);
                event.getInventory().setItem(event.getSlot(), null);
            }
        }
    }

    public void onDrag(InventoryDragEvent event) {
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int rawSlot = (Integer)iterator.next();
            if (rawSlot > 53 || !this.slot(rawSlot).locked()) continue;
            event.setCancelled(true);
            return;
        }
    }

    public void close() {
        this.actor.player().closeInventory();
    }

    public void onClose(InventoryCloseEvent event) {
        this.callAction(GuiAction.CLOSE);
    }

    private void callAction(GuiAction action) {
        this.actions.get((Object)action).forEach(method -> method.call(new GuiContext(this)));
    }

    public static Builder builder(GuiHandler instance) {
        return new Builder(instance);
    }

    public static class Builder {
        public static final GuiConstructor<Gui> DEFAULT_GUI_CONSTRUCTOR = (builder, player, inventory, slots, providedMap) -> new Gui(builder.instance(), new GuiActor(player), inventory, slots, builder.locked(), builder.labelledSlotProviders(), builder.actions(), providedMap);
        private final GuiHandler instance;
        private InventoryType inventoryType = InventoryType.CHEST;
        private int size = 27;
        private String title;
        private boolean locked = false;
        private final List<Character> slots = new ArrayList<Character>();
        private final Map<Character, SlotProvider> providers = new HashMap<Character, SlotProvider>();
        private final Multimap<GuiAction, ActionCallable> actions = HashMultimap.create();
        private final Map<Character, LabelledSlotProvider> labelProviders = new HashMap<Character, LabelledSlotProvider>();

        private Builder(GuiHandler instance) {
            this.instance = instance;
        }

        public GuiHandler instance() {
            return this.instance;
        }

        public InventoryType inventoryType() {
            return this.inventoryType;
        }

        public Builder inventoryType(InventoryType inventoryType) {
            this.inventoryType = inventoryType;
            this.size = inventoryType.getDefaultSize();
            return this;
        }

        public int size() {
            return this.size;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public String title() {
            return this.title;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public boolean locked() {
            return this.locked;
        }

        public Builder locked(boolean locked) {
            this.locked = locked;
            return this;
        }

        public Builder slot(int slot, char label) {
            while (this.slots.size() <= slot) {
                this.slots.add(null);
            }
            this.slots.set(slot, Character.valueOf(label));
            return this;
        }

        public Builder applyLayer(GuiLayer layer) {
            layer.getSlotMap().forEach((label, slot) -> this.slot((int)slot, label.charValue()));
            layer.getSlotProviders().forEach((label, provider) -> {
                Button button;
                IconProvider iconProvider = provider.iconProvider();
                if (iconProvider != IconProvider.EMPTY) {
                    this.setIconProviderFor(label.charValue(), iconProvider);
                }
                if ((button = provider.button()) != Button.EMPTY) {
                    this.setButtonFor(label.charValue(), button);
                }
            });
            return this;
        }

        public Map<Character, SlotProvider> getSlotProviders() {
            return this.providers;
        }

        public Builder setSlotProviderFor(char label, SlotProvider provider) {
            this.providers.put(Character.valueOf(label), provider);
            return this;
        }

        public Builder setIconProviderFor(char label, IconProvider provider) {
            if (this.providers.containsKey(Character.valueOf(label))) {
                this.providers.get(Character.valueOf(label)).iconProvider(provider);
            } else {
                this.providers.put(Character.valueOf(label), new SlotProvider().iconProvider(provider));
            }
            return this;
        }

        public Builder setButtonFor(char label, Button button) {
            if (this.providers.containsKey(Character.valueOf(label))) {
                this.providers.get(Character.valueOf(label)).button(button);
            } else {
                this.providers.put(Character.valueOf(label), new SlotProvider().button(button));
            }
            return this;
        }

        public Map<Character, LabelledSlotProvider> labelledSlotProviders() {
            return this.labelProviders;
        }

        public Builder setSlotProviderFor(char label, LabelledSlotProvider provider) {
            this.labelProviders.put(Character.valueOf(label), provider);
            return this;
        }

        public Multimap<GuiAction, ActionCallable> actions() {
            return this.actions;
        }

        public Builder addAction(GuiAction action, ActionCallable callable) {
            this.actions.put((Object)action, (Object)callable);
            return this;
        }

        public Builder clearActions() {
            this.actions.clear();
            return this;
        }

        public Gui open(Player player, Object ... provided) {
            return this.openWith(player, this.title, provided);
        }

        public Gui openWith(Player player, String title, Object ... provided) {
            return this.openWith(player, title, DEFAULT_GUI_CONSTRUCTOR, provided);
        }

        public <T extends Gui> T openWith(Player player, String title, GuiConstructor<T> guiConstructor, Object ... provided) {
            Slot[] slots;
            Inventory inventory;
            if (this.inventoryType == InventoryType.CHEST) {
                inventory = Bukkit.getServer().createInventory(null, this.size, ModernChatColorHandler.translate(title, player));
                slots = new Slot[this.size];
            } else {
                inventory = Bukkit.getServer().createInventory(null, this.inventoryType, ModernChatColorHandler.translate(title, player));
                slots = new Slot[this.inventoryType.getDefaultSize()];
            }
            HashMap<Character, AtomicInteger> indexes = new HashMap<Character, AtomicInteger>();
            for (int rawSlot = 0; rawSlot < slots.length; ++rawSlot) {
                Character label = Optional.ofNullable(this.slots.get(rawSlot)).orElse(Character.valueOf(' '));
                int labelIndex = indexes.computeIfAbsent(label, ignored -> new AtomicInteger()).getAndIncrement();
                Slot slot = new Slot(rawSlot, label.charValue(), labelIndex);
                SlotProvider provider = Optional.ofNullable(this.providers.get(label)).orElseGet(() -> this.instance.getDefaultProvider(label.charValue()));
                if (provider != null) {
                    slot.slotProvider(provider);
                }
                slots[rawSlot] = slot;
            }
            Map<Class<?>, Object> providedMap = Stream.of(provided).collect(Collectors.toMap(Object::getClass, obj -> obj, (existing, replacement) -> existing));
            return guiConstructor.construct(this, player, inventory, slots, providedMap);
        }
    }

    @FunctionalInterface
    public static interface GuiConstructor<T extends Gui> {
        public T construct(Builder var1, Player var2, Inventory var3, Slot[] var4, Map<Class<?>, Object> var5);
    }
}

