/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.guihandler.gui;

import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lushplugins.guihandler.slot.SlotProvider;

public class GuiLayer {
    private final List<String> rows;
    private final Map<Character, SlotProvider> providers = new HashMap<Character, SlotProvider>();

    public GuiLayer(List<String> rows) {
        if (rows.stream().anyMatch(row -> row.length() != 9)) {
            throw new IllegalArgumentException("Rows should be 9 characters long.");
        }
        this.rows = new ArrayList<String>(rows);
    }

    public GuiLayer(String ... rows) {
        this(Arrays.asList(rows));
    }

    public GuiLayer() {
        this(new ArrayList<String>());
    }

    public List<String> getRows() {
        return this.rows;
    }

    public void setRow(int index, String format) {
        if (format.length() != 9) {
            throw new IllegalArgumentException("Rows should be 9 characters long.");
        }
        this.rows.set(index, format);
    }

    public void addRow(String format) {
        if (format.length() != 9) {
            throw new IllegalArgumentException("All rows should be 9 characters long.");
        }
        this.rows.add(format);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getSize() {
        return this.rows.size() * 9;
    }

    public Map<Character, SlotProvider> getSlotProviders() {
        return this.providers;
    }

    public SlotProvider getSlotProvider(char character) {
        return this.providers.get(Character.valueOf(character));
    }

    public void setSlotProvider(char character, SlotProvider provider) {
        this.providers.put(Character.valueOf(character), provider);
    }

    public TreeMultimap<Character, Integer> getSlotMap() {
        TreeMultimap slotMap = TreeMultimap.create();
        for (int slot = 0; slot < this.getRowCount() * 9; ++slot) {
            char character = this.getCharAt(slot);
            slotMap.put((Object)Character.valueOf(character), (Object)slot);
        }
        return slotMap;
    }

    public char getCharAt(int slot) {
        int currRow = (int)Math.ceil((float)(slot + 1) / 9.0f) - 1;
        int slotInRow = slot % 9;
        return this.rows.get(currRow).charAt(slotInRow);
    }

    public int getCharCount(char character) {
        int count = 0;
        for (String row : this.rows) {
            for (int i = 0; i < row.length(); ++i) {
                if (row.charAt(i) != character) continue;
                ++count;
            }
        }
        return count;
    }
}

