/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.guihandler.libraries.chatcolorhandler.parsers.custom;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.guihandler.libraries.chatcolorhandler.parsers.Parser;

public class HexParser
implements Parser {
    public static final HexParser INSTANCE = new HexParser();
    private static final Pattern HEX_PATTERN = Pattern.compile("&(#[a-fA-F0-9]{6})");

    private HexParser() {
    }

    @Override
    public String getType() {
        return "color";
    }

    @Override
    public String parseString(@NotNull String string, @NotNull Parser.OutputType outputType) {
        Matcher match = HEX_PATTERN.matcher(string);
        return switch (outputType) {
            default -> throw new IncompatibleClassChangeError();
            case Parser.OutputType.SPIGOT -> match.replaceAll(result -> ChatColor.of((String)result.group(1)).toString());
            case Parser.OutputType.MINI_MESSAGE -> match.replaceAll("<reset><$1>");
        };
    }
}

