/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public abstract class UserCache<T> {
    protected final Map<UUID, T> userCache;

    public UserCache(JavaPlugin plugin, Map<UUID, T> cache, @Nullable org.bukkit.event.Listener listener) {
        this.userCache = cache;
        if (listener != null) {
            plugin.getServer().getPluginManager().registerEvents(listener, (Plugin)plugin);
        }
    }

    public UserCache(JavaPlugin plugin, Map<UUID, T> cache) {
        this.userCache = cache;
        plugin.getServer().getPluginManager().registerEvents(new Listener(this), (Plugin)plugin);
    }

    public UserCache(JavaPlugin plugin, org.bukkit.event.Listener listener) {
        this(plugin, new HashMap(), listener);
    }

    public UserCache(JavaPlugin plugin) {
        this(plugin, new HashMap());
    }

    @Nullable
    public T getCachedUser(UUID uuid) {
        return this.userCache.get(uuid);
    }

    public CompletableFuture<T> getUser(UUID uuid) {
        return this.getUser(uuid, true);
    }

    public CompletableFuture<T> getUser(UUID uuid, boolean cache) {
        T user = this.userCache.get(uuid);
        return user != null ? CompletableFuture.completedFuture(user) : this.loadUser(uuid, cache);
    }

    protected abstract CompletableFuture<T> load(UUID var1);

    public CompletableFuture<T> loadUser(UUID uuid) {
        return this.loadUser(uuid, true);
    }

    public CompletableFuture<T> loadUser(UUID uuid, boolean cache) {
        return this.load(uuid).thenApply(user -> {
            if (cache) {
                this.userCache.put(uuid, user);
            }
            return user;
        });
    }

    public void unloadUser(UUID uuid) {
        this.userCache.remove(uuid);
    }

    public void onUserConnect(PlayerJoinEvent event) {
        this.loadUser(event.getPlayer().getUniqueId(), true);
    }

    public void onUserDisconnect(PlayerQuitEvent event) {
        this.unloadUser(event.getPlayer().getUniqueId());
    }

    public static class Listener<T>
    implements org.bukkit.event.Listener {
        private final UserCache<T> cache;

        public Listener(UserCache<T> cache) {
            this.cache = cache;
        }

        @EventHandler
        public void onPlayerJoin(PlayerJoinEvent event) {
            this.cache.onUserConnect(event);
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            this.cache.onUserDisconnect(event);
        }
    }
}

