/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.gui.inventory;

import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lushplugins.lushtags.libraries.lushlib.gui.button.Button;

public class GuiLayer {
    private final List<String> rows;
    private final HashMap<Character, Button> buttons = new HashMap();

    public GuiLayer() {
        this.rows = new ArrayList<String>();
    }

    public GuiLayer(String ... rows) {
        this(Arrays.asList(rows));
    }

    public GuiLayer(List<String> rows) {
        this.rows = new ArrayList<String>();
        for (String row : rows) {
            if (row.length() != 9) {
                throw new IllegalArgumentException("Rows should be 9 characters long.");
            }
            this.rows.add(row);
        }
    }

    public List<String> getRows() {
        return this.rows;
    }

    public void setRow(int row, String format) {
        if (format.length() != 9) {
            throw new IllegalArgumentException("Rows should be 9 characters long.");
        }
        this.rows.set(row, format);
    }

    public void addRow(String format) {
        if (format.length() != 9) {
            throw new IllegalArgumentException("All rows should be 9 characters long.");
        }
        this.rows.add(format);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getSize() {
        return this.rows.size() * 9;
    }

    public Map<Character, Button> getButtonMap() {
        return this.buttons;
    }

    public Button getButton(char character) {
        return this.buttons.get(Character.valueOf(character));
    }

    public void setButton(char character, Button button) {
        this.buttons.put(Character.valueOf(character), button);
    }

    public TreeMultimap<Character, Integer> getSlotMap() {
        TreeMultimap slotMap = TreeMultimap.create();
        for (int slot = 0; slot < this.getRowCount() * 9; ++slot) {
            char character = this.getCharAt(slot);
            slotMap.put((Object)Character.valueOf(character), (Object)slot);
        }
        return slotMap;
    }

    public char getCharAt(int slot) {
        int currRow = (int)Math.ceil((float)(slot + 1) / 9.0f) - 1;
        int slotInRow = slot % 9;
        return this.rows.get(currRow).charAt(slotInRow);
    }

    public int getCharCount(char character) {
        int count = 0;
        for (String row : this.rows) {
            for (int i = 0; i < row.length(); ++i) {
                if (row.charAt(i) != character) continue;
                ++count;
            }
        }
        return count;
    }
}

