/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.ser.impl;

import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.annotation.ObjectIdGenerator;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.core.SerializableString;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.core.io.SerializedString;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.JavaType;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.JsonSerializer;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.PropertyName;

public final class ObjectIdWriter {
    public final JavaType idType;
    public final SerializableString propertyName;
    public final ObjectIdGenerator<?> generator;
    public final JsonSerializer<Object> serializer;
    public final boolean alwaysAsId;

    protected ObjectIdWriter(JavaType t, SerializableString propName, ObjectIdGenerator<?> gen, JsonSerializer<?> ser, boolean alwaysAsId) {
        this.idType = t;
        this.propertyName = propName;
        this.generator = gen;
        this.serializer = ser;
        this.alwaysAsId = alwaysAsId;
    }

    public static ObjectIdWriter construct(JavaType idType, PropertyName propName, ObjectIdGenerator<?> generator, boolean alwaysAsId) {
        String simpleName = propName == null ? null : propName.getSimpleName();
        SerializedString serName = simpleName == null ? null : new SerializedString(simpleName);
        return new ObjectIdWriter(idType, serName, generator, null, alwaysAsId);
    }

    public ObjectIdWriter withSerializer(JsonSerializer<?> ser) {
        return new ObjectIdWriter(this.idType, this.propertyName, this.generator, ser, this.alwaysAsId);
    }

    public ObjectIdWriter withAlwaysAsId(boolean newState) {
        if (newState == this.alwaysAsId) {
            return this;
        }
        return new ObjectIdWriter(this.idType, this.propertyName, this.generator, this.serializer, newState);
    }
}

