/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.lushtags.libraries.lushlib.LushLogger;
import org.lushplugins.lushtags.libraries.lushlib.config.ConfigSection;
import org.lushplugins.lushtags.libraries.lushlib.utils.DisplayItemStack;
import org.lushplugins.lushtags.libraries.lushlib.utils.Pair;
import org.lushplugins.lushtags.libraries.lushlib.utils.converter.YamlConverter;

public class YamlUtils {
    @NotNull
    public static List<String> getStringList(ConfigurationSection config, String path) {
        if (!config.isList(path)) {
            String key = config.getString(path);
            return key != null ? List.of(key) : Collections.emptyList();
        }
        return config.getStringList(path);
    }

    public static List<ConfigurationSection> getConfigurationSections(ConfigurationSection config, String path) {
        if (config.isList(path)) {
            return config.getMapList(path).stream().map(map -> YamlUtils.fromMap(config, path, map)).toList();
        }
        ConfigurationSection pathSection = config.getConfigurationSection(path);
        if (pathSection == null) {
            return Collections.emptyList();
        }
        return pathSection.getValues(false).values().stream().map(rawSection -> {
            ConfigurationSection configSection;
            return rawSection instanceof ConfigurationSection ? (configSection = (ConfigurationSection)rawSection) : null;
        }).filter(Objects::nonNull).toList();
    }

    private static ConfigurationSection fromMap(ConfigurationSection parent, String path, Map<?, ?> map) {
        return new ConfigSection(parent, path).createSection("list", map);
    }

    @Deprecated(forRemoval=true)
    public static DisplayItemStack.Builder getDisplayItemBuilder(ConfigurationSection section) {
        return YamlConverter.getDisplayItemBuilder(section);
    }

    @Deprecated(forRemoval=true)
    public static DisplayItemStack getDisplayItem(ConfigurationSection section) {
        return YamlConverter.getDisplayItem(section);
    }

    @Deprecated(forRemoval=true)
    public static void setDisplayItem(ConfigurationSection section, DisplayItemStack item) {
        YamlConverter.setDisplayItem(section, item);
    }

    public static List<Pair<String, YamlConfiguration>> readConfigsInDirectory(File directory) {
        ArrayList<Pair<String, YamlConfiguration>> configFiles = new ArrayList<Pair<String, YamlConfiguration>>();
        try (DirectoryStream<Path> fileStream = Files.newDirectoryStream(directory.toPath(), "*.yml");){
            for (Path filePath : fileStream) {
                File file = filePath.toFile();
                configFiles.add(new Pair<String, YamlConfiguration>(file.getName(), YamlConfiguration.loadConfiguration((File)file)));
            }
        }
        catch (IOException e) {
            LushLogger.getLogger().log(Level.WARNING, "Caught error whilst loading config files: ", e);
        }
        return configFiles;
    }
}

