/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.manager;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.lushplugins.lushtags.libraries.lushlib.LushLib;
import org.lushplugins.lushtags.libraries.lushlib.gui.inventory.Gui;
import org.lushplugins.lushtags.libraries.lushlib.listener.InventoryListener;
import org.lushplugins.lushtags.libraries.lushlib.manager.Manager;

public class GuiManager
extends Manager {
    private ConcurrentHashMap<UUID, Gui> playerGuiMap = null;

    @Override
    public void onEnable() {
        this.playerGuiMap = new ConcurrentHashMap();
        LushLib.getInstance().getPlugin().getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)LushLib.getInstance().getPlugin());
    }

    @Override
    public void onDisable() {
        if (this.playerGuiMap != null) {
            this.playerGuiMap.values().forEach(Gui::close);
            this.playerGuiMap.clear();
            this.playerGuiMap = null;
        }
    }

    public Gui getGui(UUID uuid) {
        return this.playerGuiMap.get(uuid);
    }

    public void addGui(UUID uuid, Gui gui) {
        this.playerGuiMap.put(uuid, gui);
    }

    public void removeGui(UUID uuid) {
        this.playerGuiMap.remove(uuid);
    }

    public void closeAll() {
        ((ConcurrentHashMap.KeySetView)this.playerGuiMap.keySet()).forEach(uuid -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                player.closeInventory();
            }
        });
    }
}

