/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.storage;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.lushplugins.lushtags.LushTags;
import org.lushplugins.lushtags.storage.Storage;
import org.lushplugins.lushtags.storage.type.MySQLStorage;
import org.lushplugins.lushtags.storage.type.SQLiteStorage;
import org.lushplugins.lushtags.user.TagsUser;

public class StorageManager {
    private final ExecutorService threads = Executors.newFixedThreadPool(1);
    private Storage storage;

    public StorageManager() {
        LushTags.getInstance().saveDefaultResource("storage.yml");
        this.reload();
    }

    public void disable() {
        if (this.storage != null) {
            this.runAsync(this.storage::disable);
        }
    }

    public void reload() {
        this.disable();
        FileConfiguration config = LushTags.getInstance().getConfigResource("storage.yml");
        String storageType = config.getString("type");
        if (storageType == null) {
            LushTags.getInstance().getLogger().severe("No storage type is defined");
            return;
        }
        switch (storageType) {
            case "mysql": 
            case "mariadb": {
                this.storage = new MySQLStorage();
                break;
            }
            case "sqlite": {
                this.storage = new SQLiteStorage();
                break;
            }
            default: {
                LushTags.getInstance().getLogger().severe(String.format("'%s' is not a valid storage type", storageType));
                return;
            }
        }
        this.runAsync(() -> this.storage.enable((ConfigurationSection)config));
    }

    public CompletableFuture<TagsUser> loadTagsUser(UUID uuid) {
        return this.runAsync(() -> this.storage.loadTagsUser(uuid));
    }

    public CompletableFuture<Void> saveTagsUser(TagsUser user) {
        return this.runAsync(() -> this.storage.saveTagsUser(user));
    }

    public CompletableFuture<Collection<String>> findSimilarUsernames(String input) {
        return this.runAsync(() -> this.storage.findSimilarUsernames(input));
    }

    private <T> CompletableFuture<T> runAsync(Callable<T> callable) {
        CompletableFuture future = new CompletableFuture();
        this.threads.submit(() -> {
            try {
                future.complete(callable.call());
            }
            catch (Throwable e) {
                e.printStackTrace();
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private CompletableFuture<Void> runAsync(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.threads.submit(() -> {
            try {
                runnable.run();
                future.complete(null);
            }
            catch (Throwable e) {
                e.printStackTrace();
                future.completeExceptionally(e);
            }
        });
        return future;
    }
}

