/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.storage.type;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.bukkit.configuration.ConfigurationSection;
import org.lushplugins.lushtags.LushTags;
import org.lushplugins.lushtags.storage.type.AbstractSQLStorage;

public class SQLiteStorage
extends AbstractSQLStorage {
    private static final String DATABASE_PATH = new File(LushTags.getInstance().getDataFolder(), "data.db").getAbsolutePath();

    @Override
    public void enable(ConfigurationSection config) {
        super.enable(config);
        this.runSqlFile("storage/sqlite_setup.sql");
    }

    @Override
    protected String getSaveTagsUserStatement() {
        return String.format("INSERT INTO %s (uuid, username, tags)\nVALUES (?, ?, ?)\nON CONFLICT (uuid)\nDO UPDATE SET\n    uuid = EXCLUDED.uuid,\n    username = EXCLUDED.username,\n    tags = EXCLUDED.tags;\n", "lushtags_users");
    }

    @Override
    protected Connection conn() {
        try {
            return DriverManager.getConnection("jdbc:sqlite:" + DATABASE_PATH);
        }
        catch (SQLException e) {
            LushTags.getInstance().log(Level.SEVERE, "An error occurred whilst getting a connection: ", (Throwable)e);
            return null;
        }
    }

    @Override
    protected DataSource setupDataSource(ConfigurationSection config) {
        return null;
    }
}

