/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.guihandler.libraries.chatcolorhandler.messengers;

import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.guihandler.libraries.chatcolorhandler.ModernChatColorHandler;
import org.lushplugins.guihandler.libraries.chatcolorhandler.messengers.AbstractMessenger;

public class MiniMessageMessenger
extends AbstractMessenger {
    public static final MiniMessage MINI_MESSAGE = MiniMessage.builder().tags(TagResolver.empty()).build();
    public static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    @Override
    public void sendMessage(@NotNull CommandSender recipient, @Nullable String message) {
        Player player;
        if (message == null || message.isBlank()) {
            return;
        }
        Audience audience = Audience.audience((Audience[])new Audience[]{(Audience)recipient});
        Component parsed = ModernChatColorHandler.translate(message, recipient instanceof Player ? (player = (Player)recipient) : null);
        audience.sendMessage(parsed);
    }

    @Override
    public void broadcastMessage(@Nullable String message) {
        if (message == null || message.isBlank()) {
            return;
        }
        Audience audience = Audience.audience((Audience[])new Audience[]{(Audience)Bukkit.getServer()});
        audience.sendMessage(ModernChatColorHandler.translate(message));
    }

    @Override
    public void sendActionBarMessage(@NotNull Player player, @Nullable String message) {
        if (message == null || message.isBlank()) {
            return;
        }
        Audience audience = Audience.audience((Audience[])new Audience[]{(Audience)player});
        audience.sendActionBar(ModernChatColorHandler.translate(message, player));
    }

    @Override
    public void sendTitle(@NotNull Player player, @Nullable String title, @Nullable String subtitle, int fadeIn, int stay, int fadeOut) {
        if ((title == null || title.isBlank()) && (subtitle == null || subtitle.isBlank())) {
            return;
        }
        Audience audience = Audience.audience((Audience[])new Audience[]{(Audience)player});
        Title.Times times = Title.Times.times((Duration)Duration.ofMillis((long)fadeIn * 50L), (Duration)Duration.ofMillis((long)stay * 50L), (Duration)Duration.ofMillis((long)fadeOut * 50L));
        audience.sendTitlePart(TitlePart.TIMES, (Object)times);
        audience.sendTitlePart(TitlePart.SUBTITLE, (Object)ModernChatColorHandler.translate(subtitle, player));
        audience.sendTitlePart(TitlePart.TITLE, (Object)ModernChatColorHandler.translate(title, player));
    }
}

