/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.guihandler.listener;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.lushplugins.guihandler.GuiHandler;
import org.lushplugins.guihandler.gui.Gui;

public class InventoryListener
implements Listener {
    private final GuiHandler guiHandler;

    public InventoryListener(GuiHandler guiHandler) {
        this.guiHandler = guiHandler;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Gui gui = this.guiHandler.getOpenGui(player.getUniqueId());
        if (gui == null) {
            return;
        }
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null || !player.getOpenInventory().getTopInventory().equals((Object)gui.inventory())) {
            return;
        }
        gui.onClick(event);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        Gui gui = this.guiHandler.getOpenGui(player.getUniqueId());
        if (gui == null || !event.getInventory().equals((Object)gui.inventory())) {
            return;
        }
        gui.onDrag(event);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        Gui gui = this.guiHandler.getOpenGui(player.getUniqueId());
        if (gui == null || !event.getInventory().equals((Object)gui.inventory())) {
            return;
        }
        this.guiHandler.removeOpenGui(player.getUniqueId());
        gui.onClose(event);
    }
}

