/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.deser.std;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.core.JsonParser;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.core.JsonToken;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.DeserializationContext;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.JsonMappingException;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.deser.std.StdScalarDeserializer;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.type.LogicalType;

public class AtomicBooleanDeserializer
extends StdScalarDeserializer<AtomicBoolean> {
    private static final long serialVersionUID = 1L;

    public AtomicBooleanDeserializer() {
        super(AtomicBoolean.class);
    }

    @Override
    public AtomicBoolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return new AtomicBoolean(true);
        }
        if (t == JsonToken.VALUE_FALSE) {
            return new AtomicBoolean(false);
        }
        Boolean b = this._parseBoolean(p, ctxt, AtomicBoolean.class);
        return b == null ? null : new AtomicBoolean(b);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Boolean;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return new AtomicBoolean(false);
    }
}

