/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.ser;

import java.io.Serializable;
import java.util.Map;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.core.JsonGenerator;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.BeanProperty;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.JsonMappingException;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.JsonSerializer;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.MapperFeature;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.SerializationConfig;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.SerializerProvider;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.introspect.AnnotatedMember;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.ser.BeanPropertyWriter;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.ser.ContextualSerializer;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.ser.PropertyFilter;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.databind.ser.std.MapSerializer;

public class AnyGetterWriter
extends BeanPropertyWriter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final BeanProperty _property;
    protected final AnnotatedMember _accessor;
    protected JsonSerializer<Object> _serializer;
    protected MapSerializer _mapSerializer;

    public AnyGetterWriter(BeanPropertyWriter parent, BeanProperty property, AnnotatedMember accessor, JsonSerializer<?> serializer) {
        super(parent);
        this._accessor = accessor;
        this._property = property;
        this._serializer = serializer;
        if (serializer instanceof MapSerializer) {
            this._mapSerializer = (MapSerializer)serializer;
        }
    }

    @Deprecated
    public AnyGetterWriter(BeanProperty property, AnnotatedMember accessor, JsonSerializer<?> serializer) {
        this(null, property, accessor, serializer);
    }

    @Override
    public void fixAccess(SerializationConfig config) {
        this._accessor.fixAccess(config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    public void getAndSerialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws Exception {
        Object value = this._accessor.getValue(bean);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            provider.reportBadDefinition(this._property.getType(), String.format("Value returned by 'any-getter' %s() not java.util.Map but %s", this._accessor.getName(), value.getClass().getName()));
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeWithoutTypeInfo((Map)value, gen, provider);
            return;
        }
        this._serializer.serialize(value, gen, provider);
    }

    @Override
    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        this.getAndSerialize(bean, gen, prov);
    }

    public void getAndFilter(Object bean, JsonGenerator gen, SerializerProvider provider, PropertyFilter filter) throws Exception {
        Object value = this._accessor.getValue(bean);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            provider.reportBadDefinition(this._property.getType(), String.format("Value returned by 'any-getter' (%s()) not java.util.Map but %s", this._accessor.getName(), value.getClass().getName()));
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeFilteredAnyProperties(provider, gen, bean, (Map)value, filter, null);
            return;
        }
        this._serializer.serialize(value, gen, provider);
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._serializer instanceof ContextualSerializer) {
            JsonSerializer<?> ser = provider.handlePrimaryContextualization(this._serializer, this._property);
            this._serializer = ser;
            if (ser instanceof MapSerializer) {
                this._mapSerializer = (MapSerializer)ser;
            }
        }
    }
}

