/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.skullcreator.type;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.lushtags.libraries.lushlib.skullcreator.SkullCreator;
import org.lushplugins.lushtags.libraries.lushlib.skullcreator.SkullCreatorAPI;

public class LegacySkullCreator
implements SkullCreator {
    private Method skullMetaSetProfileMethod;
    private Field skullMetaProfileField;

    @Override
    public ItemStack getCustomSkull(String texture) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof SkullMeta) {
            SkullMeta meta = (SkullMeta)itemMeta;
            this.mutateItemMeta(meta, texture);
            item.setItemMeta((ItemMeta)meta);
            return item;
        }
        return null;
    }

    @Override
    public void mutateItemMeta(SkullMeta meta, String b64) {
        try {
            if (this.skullMetaSetProfileMethod == null) {
                this.skullMetaSetProfileMethod = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                this.skullMetaSetProfileMethod.setAccessible(true);
            }
            this.skullMetaSetProfileMethod.invoke((Object)meta, this.makeProfile(b64));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            try {
                if (this.skullMetaProfileField == null) {
                    this.skullMetaProfileField = meta.getClass().getDeclaredField("profile");
                    this.skullMetaProfileField.setAccessible(true);
                }
                this.skullMetaProfileField.set(meta, this.makeProfile(b64));
            }
            catch (IllegalAccessException | NoSuchFieldException e2) {
                SkullCreatorAPI.LOGGER.log(Level.SEVERE, "Caught error whilst mutating skull meta: ", e);
            }
        }
    }

    @Override
    @Nullable
    public String getB64(ItemStack itemStack) {
        try {
            ItemMeta itemMeta;
            if (itemStack.hasItemMeta() && (itemMeta = itemStack.getItemMeta()) instanceof SkullMeta) {
                GameProfile gameProfile;
                Iterator iterator;
                SkullMeta skullMeta = (SkullMeta)itemMeta;
                if (this.skullMetaProfileField == null) {
                    this.skullMetaProfileField = skullMeta.getClass().getDeclaredField("profile");
                    this.skullMetaProfileField.setAccessible(true);
                }
                if ((iterator = (gameProfile = (GameProfile)this.skullMetaProfileField.get(skullMeta)).getProperties().get((Object)"textures").iterator()).hasNext()) {
                    Property property = (Property)iterator.next();
                    return property.getValue();
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getTexture(OfflinePlayer player) {
        Property property;
        GameProfile profile;
        try {
            Method getProfileMethod = player.getClass().getDeclaredMethod("getProfile", new Class[0]);
            profile = (GameProfile)getProfileMethod.invoke((Object)player, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return "";
        }
        try {
            property = (Property)profile.getProperties().get((Object)"textures").iterator().next();
        }
        catch (Exception e) {
            return "";
        }
        return property.getValue();
    }

    private GameProfile makeProfile(String b64) {
        UUID id = null;
        try {
            id = new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
        }
        catch (StringIndexOutOfBoundsException ex) {
            if (b64.length() == 0) {
                SkullCreatorAPI.LOGGER.warning("Missing base64 texture found - check your config");
            }
            SkullCreatorAPI.LOGGER.warning("Invalid base64 texture (" + b64 + ") found - check your config");
        }
        GameProfile profile = new GameProfile(id, "Player");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", b64));
        return profile;
    }
}

