/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.skullcreator.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.lushtags.libraries.lushlib.skullcreator.SkullCreator;
import org.lushplugins.lushtags.libraries.lushlib.skullcreator.SkullCreatorAPI;

public class ModernSkullCreator
implements SkullCreator {
    @Override
    public ItemStack getCustomSkull(String texture) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof SkullMeta) {
            SkullMeta meta = (SkullMeta)itemMeta;
            this.mutateItemMeta(meta, texture);
            item.setItemMeta((ItemMeta)meta);
            return item;
        }
        return null;
    }

    @Override
    public void mutateItemMeta(SkullMeta meta, String b64) {
        PlayerProfile ownerProfile = meta.getOwnerProfile() != null ? meta.getOwnerProfile() : this.makeProfile(b64);
        meta.setOwnerProfile(ownerProfile);
    }

    @Override
    @Deprecated
    @Nullable
    public String getB64(@NotNull ItemStack itemStack) {
        return this.getTextureValue(itemStack);
    }

    @Nullable
    public String getTextureValue(@NotNull ItemStack itemStack) {
        if (!itemStack.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return null;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        PlayerProfile ownerProfile = skullMeta.getOwnerProfile();
        if (ownerProfile == null) {
            return null;
        }
        try {
            URL skinUrl = skullMeta.getOwnerProfile().getTextures().getSkin();
            return skinUrl != null ? this.getBase64FromUrl(skinUrl) : null;
        }
        catch (Exception e) {
            SkullCreatorAPI.LOGGER.log(Level.WARNING, "Caught error whilst parsing skull item:", e);
            return null;
        }
    }

    @Override
    public String getTexture(OfflinePlayer player) {
        URL skinUrl = player.getPlayerProfile().getTextures().getSkin();
        return skinUrl != null ? this.getBase64FromUrl(skinUrl) : null;
    }

    private PlayerProfile makeProfile(String b64) {
        UUID id = null;
        try {
            id = new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
        }
        catch (StringIndexOutOfBoundsException ex) {
            if (b64.length() == 0) {
                SkullCreatorAPI.LOGGER.warning("Missing base64 texture found - check your config");
            }
            SkullCreatorAPI.LOGGER.warning("Invalid base64 texture (" + b64 + ") found - check your config");
        }
        PlayerProfile profile = Bukkit.createPlayerProfile(id, (String)"Player");
        try {
            PlayerTextures profileTextures = profile.getTextures();
            profileTextures.setSkin(this.getUrlFromBase64(b64));
            profile.setTextures(profileTextures);
        }
        catch (NullPointerException | MalformedURLException e) {
            e.printStackTrace();
        }
        return profile;
    }

    private URL getUrlFromBase64(String base64) throws MalformedURLException {
        String decoded;
        String dataRaw = new String(Base64.getDecoder().decode(base64)).toLowerCase();
        JsonObject data = JsonParser.parseString((String)dataRaw).getAsJsonObject();
        try {
            decoded = data.get("textures").getAsJsonObject().get("skin").getAsJsonObject().get("url").getAsString();
        }
        catch (NullPointerException e) {
            SkullCreatorAPI.LOGGER.severe(base64 + " does not appear to be a valid texture.");
            return null;
        }
        return new URL(decoded);
    }

    private String getBase64FromUrl(URL url) {
        byte[] urlBytes = ("{textures:{skin:{url:\"" + url.toString() + "\"}}}").getBytes();
        return new String(Base64.getEncoder().encode(urlBytes));
    }
}

