/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.lushtags.libraries.lushlib.LushLogger;
import org.lushplugins.lushtags.libraries.lushlib.libraries.chatcolor.ChatColorHandler;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.annotation.JsonAlias;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.annotation.JsonAutoDetect;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.annotation.JsonCreator;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.annotation.JsonInclude;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.annotation.JsonProperty;
import org.lushplugins.lushtags.libraries.lushlib.skullcreator.SkullCreatorAPI;
import org.lushplugins.lushtags.libraries.lushlib.utils.IntRange;

@JsonAutoDetect(isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DisplayItemStack {
    private static final DisplayItemStack EMPTY = DisplayItemStack.builder().build();
    private final Material material;
    private final IntRange amount;
    private final String displayName;
    private final List<String> lore;
    private final Boolean enchantGlow;
    private final int customModelData;
    private final String skullTexture;

    @JsonCreator
    public DisplayItemStack(@JsonProperty(value="material") @Nullable Material material, @JsonProperty(value="amount") @Nullable IntRange amount, @JsonProperty(value="displayName") @JsonAlias(value={"display-name"}) @Nullable String displayName, @JsonProperty(value="lore") @Nullable List<String> lore, @JsonProperty(value="enchantGlow") @JsonAlias(value={"enchant-glow", "enchanted"}) @Nullable Boolean enchantGlow, @JsonProperty(value="customModelData") @JsonAlias(value={"custom-model-data"}) int customModelData, @JsonProperty(value="skullTexture") @JsonAlias(value={"skull-texture"}) @Nullable String skullTexture) {
        this.material = material;
        this.amount = amount != null ? amount : new IntRange(1);
        this.displayName = displayName;
        this.lore = lore != null ? Collections.unmodifiableList(lore) : null;
        this.enchantGlow = enchantGlow;
        this.customModelData = customModelData;
        this.skullTexture = skullTexture;
    }

    @Nullable
    public Material getType() {
        return this.material;
    }

    public boolean hasType() {
        return this.material != null;
    }

    public IntRange getAmount() {
        return this.amount.clone();
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    @Nullable
    public List<String> getLore() {
        return this.lore;
    }

    public boolean hasLore() {
        return this.lore != null;
    }

    @Nullable
    public Boolean getEnchantGlow() {
        return this.enchantGlow;
    }

    public boolean hasEnchantGlow() {
        return this.enchantGlow != null;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public boolean hasCustomModelData() {
        return this.customModelData != 0;
    }

    public String getSkullTexture() {
        return this.skullTexture;
    }

    public boolean hasSkullTexture() {
        return this.skullTexture != null;
    }

    public boolean isBlank() {
        return this.material == null && this.amount.getMin() == 1 && this.amount.getMax() == 1 && this.displayName == null && this.lore == null && this.enchantGlow == null && this.customModelData == 0 && this.skullTexture == null;
    }

    public boolean hasMeta() {
        return this.hasDisplayName() || this.hasLore() || this.hasEnchantGlow() || this.hasCustomModelData() || this.hasSkullTexture();
    }

    public boolean isSimilar(@NotNull ItemStack itemStack) {
        Material material = this.getType();
        if (material != null && itemStack.getType() != material) {
            return false;
        }
        if (!(this.amount.getMin() == 1 && this.amount.getMax() == 1 || this.getAmount().contains(itemStack.getAmount()))) {
            return false;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return !this.hasMeta();
        }
        String displayName = this.getDisplayName();
        if (displayName != null && !itemMeta.getDisplayName().equals(displayName)) {
            return false;
        }
        List<String> lore = this.getLore();
        if (!(lore == null || itemMeta.getLore() != null && itemMeta.getLore().equals(lore))) {
            return false;
        }
        Boolean enchantGlow = this.getEnchantGlow();
        if (enchantGlow != null && !itemMeta.getDisplayName().equals(displayName)) {
            return false;
        }
        int customModelData = this.getCustomModelData();
        return customModelData == 0 || itemMeta.hasCustomModelData() && itemMeta.getCustomModelData() == customModelData;
    }

    public ItemStack asItemStack() {
        return this.asItemStack(null, true);
    }

    public ItemStack asItemStack(@Nullable Player player) {
        return this.asItemStack(player, true);
    }

    public ItemStack asItemStack(@Nullable Player player, boolean parseColors) {
        if (this.material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        ItemStack itemStack = new ItemStack(this.material, this.amount.next());
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            if (this.displayName != null) {
                itemMeta.setDisplayName(parseColors ? ChatColorHandler.translate(this.displayName, player) : this.displayName);
            }
            if (this.lore != null) {
                itemMeta.setLore(parseColors ? this.lore.stream().map(line -> ChatColorHandler.translate(line, player)).toList() : this.lore);
            }
            if (this.enchantGlow != null && this.enchantGlow.booleanValue()) {
                itemMeta.addEnchant(Enchantment.DURABILITY, 1, false);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (this.customModelData != 0) {
                itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
            }
            if (itemMeta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)itemMeta;
                if (this.skullTexture != null) {
                    if (this.skullTexture.equals("mirror") && player != null) {
                        String playerB64 = SkullCreatorAPI.getTexture((OfflinePlayer)player);
                        if (playerB64 != null) {
                            SkullCreatorAPI.mutateItemMeta(skullMeta, playerB64);
                        }
                    } else {
                        SkullCreatorAPI.mutateItemMeta(skullMeta, this.skullTexture);
                    }
                }
            }
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public static DisplayItemStack empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return DisplayItemStack.builder((Material)null);
    }

    public static Builder builder(Material material) {
        return new Builder(material);
    }

    public static Builder builder(ItemStack item) {
        Builder itemBuilder = DisplayItemStack.builder(item.getType()).setAmount(item.getAmount());
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null) {
            if (itemMeta.hasDisplayName()) {
                itemBuilder.setDisplayName(itemMeta.getDisplayName());
            }
            if (itemMeta.hasLore()) {
                itemBuilder.setLore(itemMeta.getLore());
            }
            if (itemMeta.hasEnchants()) {
                itemBuilder.setEnchantGlow(true);
            }
            if (itemMeta.hasCustomModelData()) {
                itemBuilder.setCustomModelData(itemMeta.getCustomModelData());
            }
            if (itemMeta instanceof SkullMeta) {
                itemBuilder.setSkullTexture(SkullCreatorAPI.getB64(item));
            }
        }
        return itemBuilder;
    }

    public static Builder builder(DisplayItemStack item) {
        return DisplayItemStack.builder().setType(item.getType()).setAmountRange(item.getAmount()).setDisplayName(item.getDisplayName()).setLore(item.getLore()).setEnchantGlow(item.getEnchantGlow()).setCustomModelData(item.getCustomModelData()).setSkullTexture(item.getSkullTexture());
    }

    public static class Builder
    implements Cloneable {
        private Material material;
        private IntRange amount = new IntRange(1);
        private String displayName = null;
        private List<String> lore = null;
        private Boolean enchantGlow = null;
        private int customModelData = 0;
        private String skullTexture = null;

        @Deprecated(forRemoval=true)
        public Builder() {
            this(null);
        }

        @Deprecated(forRemoval=true)
        public Builder(@Nullable Material material) {
            this.material = material;
        }

        @Nullable
        public Material getType() {
            return this.material;
        }

        public boolean hasType() {
            return this.material != null;
        }

        public Builder setType(@Nullable Material material) {
            this.material = material;
            return this;
        }

        public IntRange getAmount() {
            return this.amount.clone();
        }

        public Builder setAmount(int amount) {
            this.amount = new IntRange(amount);
            return this;
        }

        public Builder setAmountRange(int minAmount, int maxAmount) {
            this.amount = new IntRange(minAmount, maxAmount);
            return this;
        }

        public Builder setAmountRange(IntRange range) {
            this.amount = range;
            return this;
        }

        @Nullable
        public String getDisplayName() {
            return this.displayName;
        }

        public boolean hasDisplayName() {
            return this.displayName != null;
        }

        public Builder setDisplayName(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Nullable
        public List<String> getLore() {
            return this.lore != null ? Collections.unmodifiableList(this.lore) : null;
        }

        public boolean hasLore() {
            return this.lore != null;
        }

        public Builder setLore(@Nullable List<String> lore) {
            this.lore = lore;
            return this;
        }

        @Nullable
        public Boolean getEnchantGlow() {
            return this.enchantGlow;
        }

        public boolean hasEnchantGlow() {
            return this.enchantGlow != null;
        }

        public Builder setEnchantGlow(@Nullable Boolean enchantGlow) {
            this.enchantGlow = enchantGlow;
            return this;
        }

        public int getCustomModelData() {
            return this.customModelData;
        }

        public boolean hasCustomModelData() {
            return this.customModelData != 0;
        }

        public Builder setCustomModelData(int customModelData) {
            this.customModelData = customModelData;
            return this;
        }

        public String getSkullTexture() {
            return this.skullTexture;
        }

        public boolean hasSkullTexture() {
            return this.skullTexture != null;
        }

        public Builder setSkullTexture(@Nullable String texture) {
            this.skullTexture = texture;
            return this;
        }

        public Builder replace(CharSequence target, CharSequence replacement) {
            this.displayName = this.displayName.replace(target, replacement);
            this.lore = this.lore.stream().map(line -> line.replace(target, replacement)).toList();
            return this;
        }

        public Builder replace(CharSequence target, Callable<String> callableReplacement) {
            if (!this.displayName.contains(target) && this.lore.stream().noneMatch(str -> str.contains(target))) {
                return this;
            }
            try {
                String replacement = callableReplacement.call();
                return this.replace(target, replacement);
            }
            catch (Exception e) {
                LushLogger.getLogger().log(Level.SEVERE, "Caught exception whilst parsing replacement: ", e);
                return this;
            }
        }

        public Builder replace(Function<String, String> replacer) {
            this.displayName = replacer.apply(this.displayName);
            this.lore = this.lore.stream().map(replacer).toList();
            return this;
        }

        public DisplayItemStack build() {
            return new DisplayItemStack(this.material, this.amount, this.displayName, this.lore != null ? new ArrayList<String>(this.lore) : null, this.enchantGlow, this.customModelData, this.skullTexture);
        }

        public boolean isBlank() {
            return this.material == null && this.amount.getMin() == 1 && this.amount.getMax() == 1 && this.displayName == null && this.lore == null && this.enchantGlow == null && this.customModelData == 0 && this.skullTexture == null;
        }

        public Builder parseColors(Player player) {
            if (this.hasDisplayName()) {
                this.displayName = ChatColorHandler.translate(this.displayName, player);
            }
            if (this.hasLore()) {
                this.lore = this.lore.stream().map(line -> ChatColorHandler.translate(line, player)).toList();
            }
            return this;
        }

        public Builder overwrite(@NotNull Builder overwrite) {
            Builder result = new Builder();
            if (overwrite.hasType()) {
                result.setType(overwrite.getType());
                result.setCustomModelData(overwrite.getCustomModelData());
            } else {
                result.setType(this.material);
                result.setCustomModelData(this.customModelData);
            }
            result.setAmountRange(overwrite.getAmount().getMin() != 1 && overwrite.getAmount().getMax() != 1 ? overwrite.getAmount() : this.amount);
            result.setDisplayName(overwrite.hasDisplayName() ? overwrite.getDisplayName() : this.displayName);
            result.setLore(overwrite.hasLore() ? overwrite.getLore() : this.lore);
            result.setEnchantGlow(overwrite.hasEnchantGlow() ? overwrite.getEnchantGlow() : this.enchantGlow);
            result.setSkullTexture(overwrite.hasSkullTexture() ? overwrite.getSkullTexture() : this.skullTexture);
            return result;
        }

        public Builder overwrite(Builder ... overwrites) {
            Builder result = this;
            for (Builder overwrite : overwrites) {
                result = result.overwrite(overwrite);
            }
            return result;
        }

        public Builder clone() {
            try {
                Builder clone = (Builder)super.clone();
                clone.setAmountRange(this.amount.clone());
                clone.setLore((List<String>)(this.lore != null ? new ArrayList<String>(this.lore) : null));
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        @Deprecated(forRemoval=true)
        public static Builder of(DisplayItemStack item) {
            return DisplayItemStack.builder(item);
        }

        @Deprecated(forRemoval=true)
        public static Builder of(ItemStack item) {
            return DisplayItemStack.builder(item);
        }
    }
}

