/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.storage.type;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.bukkit.configuration.ConfigurationSection;
import org.lushplugins.lushtags.LushTags;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.core.JsonProcessingException;
import org.lushplugins.lushtags.libraries.lushlib.libraries.jackson.core.type.TypeReference;
import org.lushplugins.lushtags.storage.Storage;
import org.lushplugins.lushtags.user.TagsUser;

public abstract class AbstractSQLStorage
implements Storage {
    protected static final String USER_TABLE = "lushtags_users";
    private DataSource dataSource;

    @Override
    public void enable(ConfigurationSection config) {
        this.dataSource = this.setupDataSource(config);
        this.testDataSourceConnection();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public TagsUser loadTagsUser(UUID uuid) {
        try {
            Connection conn = this.conn();
            try {
                TagsUser tagsUser;
                block24: {
                    PreparedStatement stmt;
                    block22: {
                        TagsUser tagsUser2;
                        block23: {
                            Map<String, String> tags;
                            ResultSet results;
                            stmt = conn.prepareStatement(String.format("SELECT *\nFROM %s\nWHERE uuid = ?;\n", USER_TABLE));
                            try {
                                stmt.setString(1, uuid.toString());
                                results = stmt.executeQuery();
                                if (!results.next()) break block22;
                                try {
                                    tags = LushTags.BASIC_JSON_MAPPER.readValue(results.getString("tags"), new TypeReference<Map<String, String>>(this){});
                                }
                                catch (JsonProcessingException e) {
                                    LushTags.getInstance().getLogger().log(Level.SEVERE, "Failed to load user's tags data: ", e);
                                    TagsUser tagsUser3 = null;
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                    if (conn != null) {
                                        conn.close();
                                    }
                                    return tagsUser3;
                                }
                            }
                            catch (Throwable throwable) {
                                if (stmt != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            tagsUser2 = new TagsUser(uuid, results.getString("username"), tags);
                            if (stmt == null) break block23;
                            stmt.close();
                        }
                        return tagsUser2;
                    }
                    tagsUser = new TagsUser(uuid, null);
                    if (stmt == null) break block24;
                    stmt.close();
                }
                return tagsUser;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3;
                        throwable3.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (SQLException e) {
            LushTags.getInstance().getLogger().log(Level.SEVERE, "Failed to load user's tags data: ", e);
            return null;
        }
    }

    @Override
    public void saveTagsUser(TagsUser user) {
        try {
            Connection conn = this.conn();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.getSaveTagsUserStatement());
                try {
                    String tags;
                    try {
                        tags = LushTags.BASIC_JSON_MAPPER.writeValueAsString(user.getTags());
                    }
                    catch (JsonProcessingException e) {
                        LushTags.getInstance().getLogger().log(Level.SEVERE, "Failed to save parse user's tags data: ", e);
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        return;
                    }
                    stmt.setString(1, user.getUniqueId().toString());
                    stmt.setString(2, user.getUsername());
                    stmt.setString(3, tags);
                    stmt.execute();
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3;
                        throwable3.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (SQLException e) {
            LushTags.getInstance().getLogger().log(Level.SEVERE, "Failed to save user's tags data: ", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> findSimilarUsernames(String input) {
        try (Connection conn = this.conn();){
            ArrayList<String> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(String.format("SELECT username\nFROM %s\nWHERE username LIKE CONCAT(?, '%%')\nLIMIT 50;\n", USER_TABLE));
                try {
                    stmt.setString(1, input);
                    ArrayList<String> usernames = new ArrayList<String>();
                    ResultSet results = stmt.executeQuery();
                    while (results.next()) {
                        usernames.add(results.getString("username"));
                    }
                    arrayList = usernames;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            LushTags.getInstance().getLogger().log(Level.SEVERE, "Failed to load user's tags data: ", e);
            return null;
        }
    }

    protected abstract String getSaveTagsUserStatement();

    protected Connection conn() {
        try {
            return this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            LushTags.getInstance().log(Level.SEVERE, "An error occurred whilst getting a connection: ", (Throwable)e);
            return null;
        }
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected abstract DataSource setupDataSource(ConfigurationSection var1);

    protected void runSqlFile(String filePath) {
        String[] statements;
        String setup;
        try (InputStream in = AbstractSQLStorage.class.getClassLoader().getResourceAsStream(filePath);){
            setup = new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining(""));
        }
        catch (IOException e) {
            LushTags.getInstance().getLogger().log(Level.SEVERE, "Could not read db setup file.", e);
            e.printStackTrace();
            return;
        }
        for (String statement : statements = setup.split("\\|")) {
            try (Connection conn = this.conn();
                 PreparedStatement stmt = conn.prepareStatement(statement);){
                stmt.execute();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected void testDataSourceConnection() {
        try (Connection conn = this.conn();){
            if (!conn.isValid(1000)) {
                throw new SQLException("Could not establish database connection.");
            }
        }
        catch (SQLException e) {
            LushTags.getInstance().log(Level.SEVERE, "An error occurred whilst testing the data source ", (Throwable)e);
        }
    }
}

