/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.storage.type;

import com.mysql.cj.jdbc.MysqlDataSource;
import javax.sql.DataSource;
import org.bukkit.configuration.ConfigurationSection;
import org.lushplugins.lushtags.storage.type.AbstractSQLStorage;

public class MySQLStorage
extends AbstractSQLStorage {
    @Override
    public void enable(ConfigurationSection config) {
        super.enable(config);
        this.runSqlFile("storage/mysql_setup.sql");
    }

    @Override
    protected String getSaveTagsUserStatement() {
        return String.format("INSERT INTO %s (uuid, username, tags)\nVALUES (?, ?, ?)\nON DUPLICATE KEY UPDATE\nuuid = VALUES(uuid),\nusername = VALUES(username),\ntags = VALUES(tags);\n", "lushtags_users");
    }

    @Override
    protected DataSource setupDataSource(ConfigurationSection config) {
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setServerName(config.getString("host"));
        dataSource.setPortNumber(config.getInt("port"));
        dataSource.setDatabaseName(config.getString("database"));
        dataSource.setUser(config.getString("username"));
        dataSource.setPassword(config.getString("password"));
        return dataSource;
    }
}

