/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.tag;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lushplugins.guihandler.gui.Gui;
import org.lushplugins.guihandler.gui.GuiLayer;
import org.lushplugins.lushtags.LushTags;
import org.lushplugins.lushtags.config.GuiConfig;
import org.lushplugins.lushtags.gui.TagsGui;
import org.lushplugins.lushtags.tag.Tag;
import org.lushplugins.lushtags.tag.TagCategory;

public class TagType {
    private final String id;
    private final Map<String, Tag> tags;
    private final Map<String, TagCategory> categories;
    private final Gui.Builder gui;

    public TagType(String id, Map<String, Tag> tags, Map<String, TagCategory> categories) {
        this.id = id;
        this.tags = tags;
        this.categories = categories;
        GuiConfig guiConfig = LushTags.getInstance().getConfigManager().getGuiConfig();
        GuiLayer guiLayer = guiConfig.layer();
        this.gui = LushTags.getInstance().getGuiHandler().prepare(new TagsGui(id, null)).title(guiConfig.title()).size(guiLayer.getSize()).locked(true).applyLayer(guiLayer);
    }

    public TagType(String id, List<Tag> tags, List<TagCategory> categories) {
        this(id, tags.stream().collect(Collectors.toMap(Tag::id, tag -> tag)), categories.stream().collect(Collectors.toMap(TagCategory::id, category -> category)));
    }

    public TagType(String id) {
        this(id, new HashMap<String, Tag>(), new HashMap<String, TagCategory>());
    }

    public String getId() {
        return this.id;
    }

    public Collection<Tag> getTags() {
        return this.tags.values();
    }

    public Tag getTag(String id) {
        return this.tags.get(id);
    }

    public void addTag(Tag tag) {
        this.tags.put(tag.id(), tag);
    }

    public void addTags(Collection<Tag> tags) {
        tags.forEach(this::addTag);
    }

    public TagCategory getTagCategory(String id) {
        return this.categories.get(id);
    }

    public TagCategory getFirstTagCategory() {
        return this.categories.values().stream().findFirst().get();
    }

    public Collection<TagCategory> getTagCategories() {
        return this.categories.values();
    }

    public void addTagCategory(TagCategory category) {
        this.categories.put(category.id(), category);
    }

    public void addTagCategories(Collection<TagCategory> categories) {
        categories.forEach(this::addTagCategory);
    }

    public Gui.Builder getGui() {
        return this.gui;
    }

    public Gui.Builder getMainGui() {
        return this.gui != null ? this.gui : this.getFirstTagCategory().gui();
    }
}

