/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.placeholderhandler.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.placeholderhandler.PlaceholderHandler;
import org.lushplugins.placeholderhandler.annotation.AnnotationList;
import org.lushplugins.placeholderhandler.annotation.Placeholder;
import org.lushplugins.placeholderhandler.annotation.SubPlaceholder;
import org.lushplugins.placeholderhandler.parameter.ParameterProvider;
import org.lushplugins.placeholderhandler.parameter.PlaceholderMethod;
import org.lushplugins.placeholderhandler.parameter.PlaceholderParameter;
import org.lushplugins.placeholderhandler.placeholder.PlaceholderImpl;
import org.lushplugins.placeholderhandler.placeholder.node.LiteralNode;
import org.lushplugins.placeholderhandler.placeholder.node.PlaceholderNode;
import org.lushplugins.placeholderhandler.util.reflect.MethodCaller;
import org.lushplugins.placeholderhandler.util.reflect.MethodCallerFactory;
import org.lushplugins.placeholderhandler.util.reflect.Reflection;

public class AnnotationHandler {
    public static List<PlaceholderImpl> register(@NotNull Class<?> instanceClass, Object instance, PlaceholderHandler placeholderHandler) {
        Placeholder baseAnnotation = instanceClass.getAnnotation(Placeholder.class);
        List<Object> baseNodes = baseAnnotation != null ? Arrays.stream(baseAnnotation.value()).map(path -> Arrays.stream(path.split("_")).map(parameter -> new LiteralNode((String)parameter)).toList()).toList() : Collections.emptyList();
        ArrayList<PlaceholderImpl> placeholders = new ArrayList<PlaceholderImpl>();
        for (Method method : Reflection.getAllMethods(instanceClass)) {
            MethodCaller.BoundMethodCaller caller;
            AnnotationList annotations = new AnnotationList(method);
            if (annotations.isEmpty() || !AnnotationHandler.containsPlaceholderAnnotation(annotations)) continue;
            try {
                caller = MethodCallerFactory.defaultFactory().createFor(method).bindTo(instance);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            LinkedHashMap parameters = new LinkedHashMap();
            for (Parameter parameter : method.getParameters()) {
                String name = parameter.getName();
                Class<?> parameterClass = parameter.getType();
                ParameterProvider<?> provider = null;
                ParameterProvider.Factory providerFactory = placeholderHandler.getParameterProviderFactory(parameterClass);
                if (providerFactory != null) {
                    AnnotationList annotationList = new AnnotationList(parameter);
                    provider = providerFactory.create(parameterClass, annotationList, placeholderHandler);
                }
                if (provider == null) {
                    provider = placeholderHandler.getParameterProvider(parameterClass);
                }
                if (provider == null) {
                    throw new IllegalArgumentException("Invalid parameter type '%s' defined at method '%s' with parameter name '%s'".formatted(parameterClass.getSimpleName(), method.getName(), name));
                }
                parameters.put(name, new PlaceholderParameter(name, parameterClass, provider));
            }
            PlaceholderMethod placeholderMethod = new PlaceholderMethod(caller, parameters);
            if (annotations.contains(Placeholder.class)) {
                Placeholder methodAnnotation = annotations.get(Placeholder.class);
                for (String path2 : methodAnnotation.value()) {
                    List<PlaceholderNode> nodes = PlaceholderNode.create(path2, parameters);
                    placeholders.add(new PlaceholderImpl(nodes, placeholderMethod));
                }
            }
            if (!annotations.contains(SubPlaceholder.class)) continue;
            SubPlaceholder methodAnnotation = annotations.get(SubPlaceholder.class);
            for (String path2 : methodAnnotation.value()) {
                List<PlaceholderNode> additionalNodes = PlaceholderNode.create(path2, parameters);
                for (List list : baseNodes) {
                    ArrayList<PlaceholderNode> nodes = new ArrayList<PlaceholderNode>(list);
                    nodes.addAll(additionalNodes);
                    placeholders.add(new PlaceholderImpl(nodes, placeholderMethod));
                }
            }
        }
        return placeholders;
    }

    private static boolean containsPlaceholderAnnotation(AnnotationList annotations) {
        return annotations.contains(Placeholder.class) || annotations.contains(SubPlaceholder.class);
    }
}

