/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.placeholderhandler.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.placeholderhandler.PlaceholderHandler;
import org.lushplugins.placeholderhandler.hook.PlaceholderHook;
import org.lushplugins.placeholderhandler.placeholder.PlaceholderImpl;

public class PlaceholderAPIHook
implements PlaceholderHook {
    private final List<String> registeredIdentifiers = new ArrayList<String>();

    @Override
    public void register(PlaceholderHandler instance, Collection<PlaceholderImpl> placeholders) {
        placeholders.stream().map(placeholder -> placeholder.firstNode().name()).distinct().filter(identifier -> !this.registeredIdentifiers.contains(identifier)).forEach(identifier -> {
            new Expansion(instance, (String)identifier).register();
            this.registeredIdentifiers.add((String)identifier);
        });
    }

    public static class Expansion
    extends PlaceholderExpansion {
        private final PlaceholderHandler instance;
        private final String identifier;

        public Expansion(PlaceholderHandler instance, String identifier) {
            this.instance = instance;
            this.identifier = identifier;
        }

        public String onPlaceholderRequest(Player player, @NotNull String params) {
            String placeholder = "%" + this.identifier + "_" + params + "%";
            return this.instance.parsePlaceholder(placeholder, player);
        }

        public boolean persist() {
            return true;
        }

        public boolean canRegister() {
            return true;
        }

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }

        @NotNull
        public String getAuthor() {
            return String.join((CharSequence)", ", this.instance.plugin().getDescription().getAuthors());
        }

        @NotNull
        public String getVersion() {
            return this.instance.plugin().getDescription().getVersion();
        }
    }
}

