/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.guihandler.gui;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lushplugins.guihandler.gui.Gui;

public interface PagedGui<T> {
    public Stream<T> getContentStream(Gui var1);

    public Comparator<T> getContentSortMethod();

    default public Stream<T> getPageContentStream(Gui gui, int page, int pageSize) {
        return this.getContentStream(gui).sorted(this.getContentSortMethod()).skip((long)(page - 1) * (long)pageSize).limit(pageSize);
    }

    default public ArrayDeque<T> getPageContent(Gui gui, int page, int pageSize) {
        return this.getPageContentStream(gui, page, pageSize).collect(Collectors.toCollection(ArrayDeque::new));
    }
}

