/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.gui;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.guihandler.annotation.ButtonProvider;
import org.lushplugins.guihandler.annotation.CustomGui;
import org.lushplugins.guihandler.annotation.GuiEvent;
import org.lushplugins.guihandler.annotation.Slots;
import org.lushplugins.guihandler.gui.Gui;
import org.lushplugins.guihandler.gui.GuiAction;
import org.lushplugins.guihandler.gui.GuiActor;
import org.lushplugins.guihandler.gui.PagedGui;
import org.lushplugins.guihandler.slot.IconProvider;
import org.lushplugins.guihandler.slot.Slot;
import org.lushplugins.lushtags.LushTags;
import org.lushplugins.lushtags.libraries.lushlib.libraries.chatcolor.ChatColorHandler;
import org.lushplugins.lushtags.libraries.lushlib.utils.DisplayItemStack;
import org.lushplugins.lushtags.tag.Tag;
import org.lushplugins.lushtags.tag.TagType;
import org.lushplugins.lushtags.user.TagsUser;

@CustomGui
public record TagsGui(String tagType, @Nullable String category) implements PagedGui<Tag>
{
    @GuiEvent(value=GuiAction.REFRESH)
    public void tags(Gui gui, @Slots(value={116}) List<Slot> slots) {
        GuiActor actor = gui.actor();
        TagsUser user = (TagsUser)LushTags.getInstance().getUserCache().getCachedUser(actor.uuid());
        if (user == null) {
            return;
        }
        DisplayItemStack tagIcon = LushTags.getInstance().getTagManager().getTagType(this.tagType).getTagCategory(this.category).tagIcon();
        ArrayDeque tags = this.getPageContent(gui, gui.page(), slots.size());
        for (Slot slot : slots) {
            if (tags.isEmpty()) {
                slot.iconProvider(IconProvider.EMPTY);
                continue;
            }
            Tag tag = (Tag)tags.pop();
            DisplayItemStack icon = DisplayItemStack.builder(tagIcon).replace(str -> str.replace("%tag%", tag.tag()).replace("%tag_name%", tag.name())).build();
            slot.icon(icon.asItemStack(actor.player()));
            slot.button(context -> {
                Player player = actor.player();
                if (tag.canBeUsedBy(player)) {
                    user.setTag(this.tagType, tag.id());
                    ChatColorHandler.sendMessage((CommandSender)player, LushTags.getInstance().getConfigManager().getMessage("set-tag").replace("%tag_type%", this.tagType).replace("%tag%", tag.tag()).replace("%tag_name%", tag.name()));
                } else {
                    ChatColorHandler.sendMessage((CommandSender)player, LushTags.getInstance().getConfigManager().getMessage("no-permission"));
                }
            });
        }
    }

    @ButtonProvider(value={114})
    public void removeTagButton(GuiActor actor) {
        TagsUser user = (TagsUser)LushTags.getInstance().getUserCache().getCachedUser(actor.uuid());
        if (user == null) {
            return;
        }
        TagType tagType = LushTags.getInstance().getTagManager().getTagType(this.tagType);
        if (tagType == null) {
            return;
        }
        for (String defaultTagId : tagType.getDefaultTags()) {
            Tag defaultTag = tagType.getTag(defaultTagId);
            if (defaultTag == null || !defaultTag.canBeUsedBy(actor.player())) continue;
            user.setTag(tagType.getId(), defaultTagId);
            ChatColorHandler.sendMessage((CommandSender)actor.player(), LushTags.getInstance().getConfigManager().getMessage("remove-tag").replace("%tag_type%", this.tagType));
            return;
        }
        user.removeTag(this.tagType);
        ChatColorHandler.sendMessage((CommandSender)actor.player(), LushTags.getInstance().getConfigManager().getMessage("remove-tag").replace("%tag_type%", this.tagType));
    }

    @ButtonProvider(value={62})
    public void nextPageButton(Gui gui, @Slots(value={116}) List<Slot> slots) {
        int pageSize = slots.size();
        Stream content = this.getPageContentStream(gui, gui.page(), pageSize);
        if (content.count() == (long)pageSize) {
            gui.nextPage();
        }
    }

    @ButtonProvider(value={60})
    public void prevPageButton(Gui gui) {
        if (gui.page() > 1) {
            gui.previousPage();
        }
    }

    @Override
    public Stream<Tag> getContentStream(Gui gui) {
        TagType tagType = LushTags.getInstance().getTagManager().getTagType(this.tagType);
        if (tagType == null) {
            return Stream.empty();
        }
        return tagType.getTags().stream().filter(tag -> this.category == null || Objects.equals(tag.category(), this.category));
    }

    @Override
    public Comparator<Tag> getContentSortMethod() {
        return Comparator.comparing(Tag::id);
    }
}

