/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.plugin;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.commons.io.FilenameUtils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.lushtags.libraries.lushlib.command.Command;
import org.lushplugins.lushtags.libraries.lushlib.hook.Hook;
import org.lushplugins.lushtags.libraries.lushlib.manager.Manager;
import org.lushplugins.lushtags.libraries.lushlib.module.Module;

public abstract class SpigotPlugin
extends JavaPlugin {
    protected ConcurrentHashMap<String, Module> modules = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<? extends Manager>, Manager> managers = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Hook> hooks = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Command> commands = new ConcurrentHashMap();

    public void ifPluginPresent(String pluginName, Runnable runnable) {
        if (this.getServer().getPluginManager().getPlugin(pluginName) != null) {
            this.getLogger().info("Found plugin \"" + pluginName + "\". Enabling " + pluginName + " support.");
            runnable.run();
        }
    }

    public void ifPluginEnabled(String pluginName, Runnable runnable) {
        JavaPlugin plugin;
        Plugin plugin2 = this.getServer().getPluginManager().getPlugin(pluginName);
        if (plugin2 instanceof JavaPlugin && (plugin = (JavaPlugin)plugin2).isEnabled()) {
            this.getLogger().info("Found plugin \"" + pluginName + "\". Enabling " + pluginName + " support.");
            runnable.run();
        }
    }

    public Collection<Module> getModules() {
        return this.modules.values();
    }

    public Optional<Module> getModule(String moduleId) {
        return Optional.ofNullable(this.modules.get(moduleId));
    }

    public void registerModule(Module module) {
        if (this.modules.containsKey(module.getId())) {
            this.log(Level.SEVERE, "Failed to register module with id '" + module.getId() + "', a module with this id is already registered");
            return;
        }
        this.modules.put(module.getId(), module);
    }

    public void unregisterModule(String moduleId) {
        if (this.modules.containsKey(moduleId)) {
            this.modules.get(moduleId).disable();
            this.modules.remove(moduleId);
        }
    }

    public void unregisterAllModules() {
        this.modules.values().forEach(Module::disable);
        this.modules.clear();
    }

    public <T extends Manager> Optional<T> getManager(Class<T> clazz) {
        return this.managers.containsKey(clazz) ? Optional.of(this.managers.get(clazz)) : Optional.empty();
    }

    public void registerManager(Manager ... managers) {
        if (this.managers == null) {
            this.managers = new ConcurrentHashMap();
        }
        for (Manager manager : managers) {
            this.managers.put(manager.getClass(), manager);
            manager.enable();
        }
    }

    public void unregisterManager(Class<? extends Manager> clazz) {
        Manager manager = this.managers.get(clazz);
        if (manager != null) {
            manager.disable();
            this.managers.remove(clazz);
        }
    }

    public Collection<Hook> getHooks() {
        return this.hooks.values();
    }

    public Optional<Hook> getHook(String hookId) {
        return Optional.ofNullable(this.hooks.get(hookId));
    }

    public void registerHook(Hook hook) {
        if (this.hooks.containsKey(hook.getId())) {
            this.log(Level.SEVERE, "Failed to register hook with id '" + hook.getId() + "', a hook with this id is already registered");
            return;
        }
        this.hooks.put(hook.getId(), hook);
    }

    public void unregisterHook(String hookId) {
        if (this.hooks.containsKey(hookId)) {
            this.hooks.get(hookId).disable();
            this.hooks.remove(hookId);
        }
    }

    public void unregisterAllHooks() {
        this.hooks.values().forEach(Module::disable);
        this.hooks.clear();
    }

    @Deprecated
    public void addHook(String pluginName, Runnable runnable) {
        this.ifPluginPresent(pluginName, runnable);
    }

    public Command getLushCommand(String name) {
        return this.commands.get(name);
    }

    public void registerListener(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void registerListeners(Listener ... listeners) {
        PluginManager pluginManager = this.getServer().getPluginManager();
        for (Listener listener : listeners) {
            pluginManager.registerEvents(listener, (Plugin)this);
        }
    }

    public void registerCommand(Command command) {
        this.registerCommand(command.getName(), command, command.getRequiredPermission());
    }

    public void registerCommand(String commandName, CommandExecutor executor, @Nullable String permission) {
        PluginCommand command = this.getCommand(commandName);
        if (command == null) {
            this.getLogger().severe("Failed to register command '" + commandName + "', make sure the command has been defined in the plugin.yml");
            return;
        }
        command.setExecutor(executor);
        command.setPermission(permission);
    }

    public boolean callEvent(Event event) {
        Bukkit.getServer().getPluginManager().callEvent(event);
        if (event instanceof Cancellable) {
            Cancellable cancellable = (Cancellable)event;
            return !cancellable.isCancelled();
        }
        return true;
    }

    public NamespacedKey namespacedKey(String key) {
        return new NamespacedKey((Plugin)this, key);
    }

    public FileConfiguration getConfigResource(String path) {
        return YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), path));
    }

    public void saveDefaultResource(String path) {
        if (!new File(this.getDataFolder(), path).exists()) {
            this.saveResource(path, false);
            this.getLogger().info("File Created: " + path);
        }
    }

    public void backupFile(File file) {
        String name;
        File parent = file.getParentFile();
        if (!file.renameTo(new File(parent, FilenameUtils.removeExtension((String)(name = file.getName())) + "-old-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd-MM-yyyy--HH-mm-ss")) + ".yml"))) {
            this.getLogger().severe("Failed to rename file '" + name + "'");
        }
    }

    public void debug(@NotNull String message) {
        this.log(Level.FINE, message);
    }

    public void debug(@NotNull String message, @NotNull Throwable throwable) {
        this.log(Level.FINE, message, throwable);
    }

    @Deprecated
    public void debug(@NotNull String message, Throwable ... throwables) {
        this.log(Level.FINE, message, throwables);
    }

    public void log(@NotNull Level level, @NotNull String message) {
        this.getLogger().log(level, message);
    }

    public void log(@NotNull Level level, @NotNull String message, @NotNull Throwable throwable) {
        this.getLogger().log(level, message, throwable);
    }

    @Deprecated
    public void log(@NotNull Level level, @NotNull String message, Throwable ... throwables) {
        if (throwables.length > 0) {
            for (Throwable throwable : throwables) {
                this.getLogger().log(level, message, throwable);
            }
        } else {
            this.getLogger().log(level, message);
        }
    }
}

