/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.libraries.lushlib.utils.converter;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.lushplugins.lushtags.libraries.lushlib.gui.button.SimpleItemButton;
import org.lushplugins.lushtags.libraries.lushlib.gui.inventory.GuiBlueprint;
import org.lushplugins.lushtags.libraries.lushlib.gui.inventory.GuiLayer;
import org.lushplugins.lushtags.libraries.lushlib.registry.RegistryUtils;
import org.lushplugins.lushtags.libraries.lushlib.utils.DisplayItemStack;
import org.lushplugins.lushtags.libraries.lushlib.utils.IntRange;
import org.lushplugins.lushtags.libraries.lushlib.utils.YamlUtils;

public class YamlConverter {
    public static DisplayItemStack.Builder getDisplayItemBuilder(ConfigurationSection section) {
        DisplayItemStack.Builder itemBuilder = DisplayItemStack.builder();
        if (section.contains("material")) {
            itemBuilder.setType((Material)RegistryUtils.parseString(section.getString("material"), Registry.MATERIAL));
        }
        if (section.contains("amount")) {
            itemBuilder.setAmountRange(IntRange.parseIntRange(section.getString("amount", "1")));
        }
        if (section.contains("display-name")) {
            itemBuilder.setDisplayName(section.getString("display-name"));
        }
        if (section.contains("lore")) {
            itemBuilder.setLore(section.getStringList("lore"));
        }
        if (section.contains("enchanted")) {
            itemBuilder.setEnchantGlow(section.getBoolean("enchanted"));
        }
        if (section.contains("custom-model-data")) {
            itemBuilder.setCustomModelData(section.getInt("custom-model-data"));
        }
        if (section.contains("skull-texture")) {
            itemBuilder.setSkullTexture(section.getString("skull-texture"));
        }
        return itemBuilder;
    }

    public static DisplayItemStack getDisplayItem(ConfigurationSection section) {
        return YamlConverter.getDisplayItemBuilder(section).build();
    }

    public static void setDisplayItem(ConfigurationSection section, DisplayItemStack item) {
        String skullTexture;
        int customModelData;
        Boolean enchantGlow;
        List<String> lore;
        String displayName;
        IntRange amount;
        Material material = item.getType();
        if (material != null) {
            section.set("material", (Object)material.name());
        }
        if ((amount = item.getAmount()).getMin() != 1 && amount.getMax() != 1) {
            section.set("amount", (Object)amount);
        }
        if ((displayName = item.getDisplayName()) != null) {
            section.set("display-name", (Object)displayName);
        }
        if ((lore = item.getLore()) != null) {
            section.set("lore", lore);
        }
        if ((enchantGlow = item.getEnchantGlow()) != null) {
            section.set("enchanted", (Object)enchantGlow);
        }
        if ((customModelData = item.getCustomModelData()) != 0) {
            section.set("custom-model-data", (Object)customModelData);
        }
        if ((skullTexture = item.getSkullTexture()) != null) {
            section.set("skull-texture", (Object)skullTexture);
        }
    }

    public static GuiBlueprint getGuiBlueprint(@NotNull ConfigurationSection guiConfig) {
        GuiLayer layer = new GuiLayer(guiConfig.getStringList("format"));
        for (ConfigurationSection buttonSection : YamlUtils.getConfigurationSections(guiConfig, "buttons")) {
            DisplayItemStack item = YamlConverter.getDisplayItem(buttonSection);
            SimpleItemButton button = new SimpleItemButton(item, ignored -> {});
            layer.setButton(buttonSection.getName().charAt(0), button);
        }
        return new GuiBlueprint(guiConfig.getString("title"), layer);
    }
}

