/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.tag;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.guihandler.gui.Gui;
import org.lushplugins.guihandler.gui.GuiLayer;
import org.lushplugins.lushtags.LushTags;
import org.lushplugins.lushtags.config.TagsConfig;
import org.lushplugins.lushtags.gui.TagsGui;
import org.lushplugins.lushtags.libraries.lushlib.utils.FilenameUtils;
import org.lushplugins.lushtags.libraries.lushlib.utils.YamlUtils;
import org.lushplugins.lushtags.tag.Tag;
import org.lushplugins.lushtags.tag.TagCategory;
import org.lushplugins.lushtags.tag.TagType;

public class TagManager {
    private Map<String, TagType> tagTypes;

    public TagManager() {
        if (!new File(LushTags.getInstance().getDataFolder(), "tags").exists()) {
            LushTags.getInstance().saveDefaultResource("tags/tags.yml");
        }
    }

    public void reloadTags() {
        this.tagTypes = new HashMap<String, TagType>();
        Path tagsDirectoryPath = LushTags.getInstance().getDataPath().resolve("tags");
        try (DirectoryStream<Path> fileStream = Files.newDirectoryStream(tagsDirectoryPath, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path filePath : fileStream) {
                File directory = filePath.toFile();
                this.loadTagTypeFromDirectory(directory);
            }
        }
        catch (IOException e) {
            LushTags.getInstance().getLogger().log(Level.WARNING, "Caught error whilst loading tags: ", e);
        }
        this.loadTagTypeFromDirectory(tagsDirectoryPath.toFile());
        if (this.tagTypes.isEmpty()) {
            throw new IllegalStateException("Failed to find any tags in tags directory");
        }
    }

    public TagType getTagType(String id) {
        return this.tagTypes.get(id);
    }

    public Collection<TagType> getTagTypes() {
        return this.tagTypes.values();
    }

    public Set<String> getTagTypeIds() {
        return this.tagTypes.keySet();
    }

    @NotNull
    private List<Tag> readTagsFromConfig(ConfigurationSection config, String defaultCategory) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        List<ConfigurationSection> tagSections = YamlUtils.getConfigurationSections(config, "tags");
        for (ConfigurationSection tagSection : tagSections) {
            String id = tagSection.contains("id") ? tagSection.getString("id") : tagSection.getName();
            String name = tagSection.getString("name");
            String tagString = tagSection.getString("tag");
            String category = tagSection.getString("category", defaultCategory);
            String permission = tagSection.getString("permission");
            Tag tag = new Tag(id, name, tagString, category, permission);
            tags.add(tag);
        }
        return tags;
    }

    @Nullable
    private List<Tag> readTagsFromFile(File file) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (!config.getBoolean("enabled", true)) {
            return null;
        }
        return this.readTagsFromConfig((ConfigurationSection)config, FilenameUtils.removeExtension(file.getName()));
    }

    private List<Tag> readTagsFromDirectory(File directory) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try (DirectoryStream<Path> fileStream = Files.newDirectoryStream(directory.toPath(), "*.yml");){
            for (Path filePath : fileStream) {
                File file = filePath.toFile();
                List<Tag> fileTags = this.readTagsFromFile(file);
                if (fileTags == null || fileTags.isEmpty()) continue;
                tags.addAll(fileTags);
            }
        }
        catch (IOException e) {
            LushTags.getInstance().getLogger().log(Level.WARNING, "Caught error whilst loading tags: ", e);
        }
        return tags;
    }

    private void loadTagTypeFromDirectory(File directory) {
        String tagTypeId = directory.getName();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ArrayList<TagCategory> categories = new ArrayList<TagCategory>();
        List<String> defaultTags = Collections.emptyList();
        try (DirectoryStream<Path> fileStream = Files.newDirectoryStream(directory.toPath(), "*.yml");){
            for (Path filePath : fileStream) {
                GuiLayer guiLayer;
                String title;
                TagsConfig tagsConfig;
                File file = filePath.toFile();
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                if (!config.getBoolean("enabled", true)) continue;
                if (file.getName().equals(".settings.yml")) {
                    if (config.contains("defaults")) {
                        defaultTags = YamlUtils.getStringList((ConfigurationSection)config, "defaults");
                        continue;
                    }
                    if (!config.contains("default")) continue;
                    defaultTags = YamlUtils.getStringList((ConfigurationSection)config, "default");
                    continue;
                }
                try {
                    tagsConfig = LushTags.YAML_MAPPER.readValue(file, TagsConfig.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String categoryId = FilenameUtils.removeExtension(file.getName());
                tags.addAll(this.readTagsFromConfig((ConfigurationSection)config, categoryId));
                if (tagsConfig.gui() != null) {
                    guiConfig = tagsConfig.gui();
                    title = guiConfig.title();
                    guiLayer = guiConfig.layer();
                } else {
                    guiConfig = LushTags.getInstance().getConfigManager().getGuiConfig();
                    title = guiConfig.title();
                    guiLayer = guiConfig.layer();
                }
                Gui.Builder gui = LushTags.getInstance().getGuiHandler().prepare(new TagsGui(tagTypeId, categoryId)).title(title).size(guiLayer.getSize()).locked(true).applyLayer(guiLayer);
                categories.add(new TagCategory(categoryId, tagTypeId, tagsConfig.commands(), gui, tagsConfig.getTagIcon()));
            }
        }
        catch (IOException e) {
            LushTags.getInstance().getLogger().log(Level.WARNING, "Caught error whilst loading tags: ", e);
        }
        if (!tags.isEmpty() && !categories.isEmpty()) {
            TagType tagType = this.tagTypes.computeIfAbsent(tagTypeId, TagType::new);
            tagType.addTags(tags);
            tagType.addTagCategories(categories);
            tagType.setDefaultTags(defaultTags);
        }
    }
}

