/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.lushtags.user;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.lushtags.LushTags;
import org.lushplugins.lushtags.tag.Tag;
import org.lushplugins.lushtags.tag.TagType;

public class TagsUser {
    private final UUID uuid;
    private final String username;
    private final Map<String, String> tags;

    public TagsUser(UUID uuid, @Nullable String username, Map<String, String> tags) {
        this.uuid = uuid;
        this.username = username;
        this.tags = tags;
    }

    public TagsUser(UUID uuid, @Nullable String username) {
        this(uuid, username, new HashMap<String, String>());
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getTagId(String tagType) {
        return this.tags.get(tagType);
    }

    @Nullable
    public Tag getTag(String tagTypeId) {
        TagType tagType = LushTags.getInstance().getTagManager().getTagType(tagTypeId);
        if (tagType == null) {
            return null;
        }
        String tagId = this.getTagId(tagTypeId);
        return tagType.getTag(tagId);
    }

    public void setTag(String tagType, String tagId) {
        this.tags.put(tagType, tagId);
        LushTags.getInstance().getStorageManager().saveTagsUser(this);
    }

    public void removeTag(String tagType) {
        this.tags.remove(tagType);
        LushTags.getInstance().getStorageManager().saveTagsUser(this);
    }

    public Map<String, String> getTags() {
        return this.tags;
    }
}

