/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.parameters;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.exception.InvalidWorldException;
import revxrsal.commands.node.ExecutionContext;
import revxrsal.commands.parameter.ParameterType;
import revxrsal.commands.stream.MutableStringStream;
import revxrsal.commands.util.Collections;

public final class WorldParameterType
implements ParameterType<BukkitCommandActor, World> {
    @Override
    public World parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<BukkitCommandActor> context) {
        String name = input.readString();
        if (name.equals("self") || name.equals("me") || name.equals("mine")) {
            return context.actor().requirePlayer().getWorld();
        }
        World world = Bukkit.getWorld((String)name);
        if (world != null) {
            return world;
        }
        throw new InvalidWorldException(name);
    }

    @Override
    @NotNull
    public SuggestionProvider<BukkitCommandActor> defaultSuggestions() {
        return context -> Collections.map(Bukkit.getWorlds(), World::getName);
    }
}

