/*
 * Decompiled with CFR 0.152.
 */
package nl.toent.bloomysettingsimport.gui;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WText;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WToggleButton;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.ItemIcon;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_429;
import net.minecraft.class_437;

public class importOptionsGui
extends LightweightGuiDescription {
    public importOptionsGui() {
        WGridPanel root = new WGridPanel();
        this.setRootPanel((WPanel)root);
        root.setSize(292, 240);
        root.setInsets(Insets.ROOT_PANEL);
        WText resultText = new WText((class_2561)class_2561.method_43473());
        root.add((WWidget)resultText, 0, 8, 16, 3);
        WButton openFileExplorerButton = new WButton((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.open_explorer"));
        openFileExplorerButton.setIcon((Icon)new ItemIcon(new class_1799((class_1935)class_1802.field_27070)));
        root.add((WWidget)openFileExplorerButton, 0, 0, 8, 1);
        openFileExplorerButton.setOnClick(() -> {
            String filePath = String.valueOf(FabricLoader.getInstance().getConfigDir());
            resultText.setText(class_2561.method_30163((String)filePath));
            try {
                Runtime.getRuntime().exec("explorer.exe /select,\"" + filePath + "\"");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        WTextField pathDirectory = new WTextField(class_2561.method_30163((String)"Enter your file directory to save to/load from!"));
        pathDirectory.setMaxLength(100);
        root.add((WWidget)pathDirectory, 0, 2, 16, 2);
        WButton importSettingsButton = new WButton((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.import_settings"));
        importSettingsButton.setIcon((Icon)new ItemIcon(new class_1799((class_1935)class_1802.field_8674)));
        root.add((WWidget)importSettingsButton, 0, 4, 8, 1);
        importSettingsButton.setOnClick(() -> {
            Path userInputtedPath = Path.of(pathDirectory.getText().replace("\"", "").replace("'", "") + FileSystems.getDefault().getSeparator(), new String[0]);
            Path findOptions = userInputtedPath.resolve("options.txt");
            Path findOriginalOptions = FabricLoader.getInstance().getConfigDir().resolve(class_310.method_1551().field_1690.method_37294().toPath());
            try {
                Files.copy(findOptions, findOriginalOptions, StandardCopyOption.REPLACE_EXISTING);
                class_310.method_1551().field_1690.method_1636();
                resultText.setText((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.import_success"));
            }
            catch (IOException e) {
                resultText.setText((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.import_failed"));
            }
        });
        WToggleButton replaceIfDuplicateTogg = new WToggleButton((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.replace_dupes"));
        replaceIfDuplicateTogg.setToggle(true);
        root.add((WWidget)replaceIfDuplicateTogg, 9, 6);
        WToggleButton addDirTogg = new WToggleButton((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.create_dir"));
        addDirTogg.setToggle(true);
        root.add((WWidget)addDirTogg, 9, 7);
        WButton exportSettingsButton = new WButton((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.export_settings"));
        exportSettingsButton.setIcon((Icon)new ItemIcon(new class_1799((class_1935)class_1802.field_8360)));
        root.add((WWidget)exportSettingsButton, 0, 6, 8, 1);
        exportSettingsButton.setOnClick(() -> {
            Path userInputtedPath = Path.of(pathDirectory.getText().replace("\"", "").replace("'", ""), new String[0]);
            Path optionsToExport = FabricLoader.getInstance().getConfigDir().resolve(class_310.method_1551().field_1690.method_37294().toPath());
            Path targetPath = userInputtedPath.resolve("options.txt");
            try {
                if (!Files.exists(userInputtedPath, new LinkOption[0]) && addDirTogg.getToggle()) {
                    Files.createDirectories(userInputtedPath, new FileAttribute[0]);
                }
                if (replaceIfDuplicateTogg.getToggle()) {
                    Files.copy(optionsToExport, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    resultText.setText((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.export_success"));
                } else {
                    Files.copy(optionsToExport, targetPath, new CopyOption[0]);
                    resultText.setText((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.export_success"));
                }
                Runtime.getRuntime().exec("explorer.exe /select,\"" + String.valueOf(targetPath) + "\"");
            }
            catch (IOException e) {
                if (e.getMessage().contains("FileAlreadyExistsException")) {
                    resultText.setText((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.file_already_exists"));
                }
                resultText.setText((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.export_failed"));
            }
        });
        WButton btnDone = new WButton((class_2561)class_2561.method_43471((String)"settings.bloomysettingsimport.exit_bsi"));
        root.add((WWidget)btnDone, 4, 11, 8, 1);
        btnDone.setOnClick(() -> {
            class_310.method_1551().field_1690.method_1636();
            class_310.method_1551().method_1507((class_437)new class_429(null, class_310.method_1551().field_1690));
        });
        root.validate((GuiDescription)this);
    }
}

