/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.common.entity.ai.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tallestegg.bigbrain.common.capabilities.BigBrainCapabilities;

public class HuskBurrowGoal
extends Goal {
    protected Husk husk;
    private int burrowTime;
    private int waitUntilDigTime;
    private BurrowPhases phase;
    private long canUseCheck;
    private int seeTime;

    public HuskBurrowGoal(Husk husk) {
        this.husk = husk;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long gameTime = this.husk.m_9236_().m_46467_();
        LivingEntity target = this.husk.m_5448_();
        return gameTime - this.canUseCheck > 100L && !this.husk.m_6162_() && target != null && !target.m_20159_() && (double)target.m_20270_((Entity)this.husk) >= 5.0 && target instanceof Player && this.husk.m_20075_().m_204336_(BlockTags.f_13029_);
    }

    public boolean m_8045_() {
        LivingEntity target = this.husk.m_5448_();
        return target != null && this.burrowTime > 0 && this.phase != BurrowPhases.STOP || this.entityInWall(this.husk) && this.phase == BurrowPhases.DIG_OUT && this.phase != BurrowPhases.STOP || this.husk.m_21225_() != null && this.husk.f_20898_ >= this.husk.m_21233_() / 2.0f || this.burrowTime <= 0 && this.phase == BurrowPhases.BURROW || target != null && !this.husk.m_21574_().m_148306_((Entity)target) && this.seeTime < -60 || this.husk.isInFluidType();
    }

    public void m_8056_() {
        this.husk.m_21561_(true);
        this.burrowTime = 40;
        this.waitUntilDigTime = 40;
        this.phase = BurrowPhases.START;
    }

    public void m_8037_() {
        LivingEntity target = this.husk.m_5448_();
        Path path = this.husk.m_21573_().m_26570_();
        if (path != null && !path.m_77392_()) {
            Node node = path.m_77402_();
            Node nextNode = path.m_77401_();
            if (!(node == null || nextNode == null || this.husk.m_9236_().m_8055_(nextNode.m_77288_()).m_204336_(BlockTags.f_13029_) && this.husk.m_9236_().m_8055_(node.m_77288_()).m_204336_(BlockTags.f_13029_))) {
                return;
            }
        }
        if (target != null) {
            boolean canSee = this.husk.m_21574_().m_148306_((Entity)target);
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (canSee != this.seeTime > 0) {
                this.seeTime = 0;
            }
            if (this.phase == BurrowPhases.START) {
                this.husk.m_20124_(Pose.SWIMMING);
                BigBrainCapabilities.getBurrowing((LivingEntity)this.husk).setBurrowing(true);
                this.phase = BurrowPhases.BURROW;
            } else if (this.phase == BurrowPhases.BURROW) {
                this.husk.m_21573_().m_5624_((Entity)target, 1.8);
                if (this.husk.m_217066_(target)) {
                    this.husk.m_21573_().m_26573_();
                    this.husk.m_20124_(Pose.STANDING);
                    this.phase = BurrowPhases.GRAB;
                }
            }
            if (this.phase == BurrowPhases.GRAB) {
                if (!target.m_20159_()) {
                    target.m_7998_((Entity)this.husk, true);
                } else {
                    this.phase = BurrowPhases.END;
                }
                BigBrainCapabilities.getBurrowing((LivingEntity)this.husk).setCarrying(true);
                this.phase = BurrowPhases.SINK;
            }
        }
        if (this.phase == BurrowPhases.SINK) {
            --this.waitUntilDigTime;
            if (this.waitUntilDigTime <= 0) {
                BigBrainCapabilities.getBurrowing((LivingEntity)this.husk).setBurrowing(false);
                BigBrainCapabilities.getBurrowing((LivingEntity)this.husk).setDigging(true);
                this.husk.f_19794_ = true;
                this.husk.m_20334_(0.0, -4.0, 0.0);
                this.phase = BurrowPhases.DIG_OUT;
            }
        } else if (this.phase == BurrowPhases.DIG_OUT) {
            if (this.entityInWall(this.husk)) {
                if (!this.husk.m_20197_().isEmpty()) {
                    this.husk.m_20153_();
                }
                BigBrainCapabilities.getBurrowing((LivingEntity)this.husk).setCarrying(false);
                this.husk.m_20334_(0.0, 0.5, 0.0);
            } else {
                BigBrainCapabilities.getBurrowing((LivingEntity)this.husk).setDigging(false);
                this.phase = BurrowPhases.END;
            }
        }
        if (this.phase == BurrowPhases.END || this.husk.m_21225_() != null && this.husk.f_20898_ >= this.husk.m_21233_() / 2.0f || this.burrowTime <= 0 && this.phase == BurrowPhases.BURROW || target != null && !this.husk.m_21574_().m_148306_((Entity)target) && this.seeTime < -60 || this.husk.isInFluidType()) {
            this.phase = BurrowPhases.STOP;
        }
        if (this.phase == BurrowPhases.BURROW) {
            --this.burrowTime;
        }
    }

    public void m_8041_() {
        BigBrainCapabilities.getBurrowing((LivingEntity)this.husk).setBurrowing(false);
        BigBrainCapabilities.getBurrowing((LivingEntity)this.husk).setCarrying(false);
        BigBrainCapabilities.getBurrowing((LivingEntity)this.husk).setDigging(false);
        this.husk.m_20124_(Pose.STANDING);
        this.husk.f_19794_ = false;
        if (!this.husk.m_20197_().isEmpty()) {
            this.husk.m_20153_();
        }
        this.canUseCheck = this.husk.m_9236_().m_46467_();
        this.burrowTime = 0;
        this.waitUntilDigTime = 0;
        this.husk.m_21561_(false);
    }

    public boolean m_183429_() {
        return true;
    }

    private boolean entityInWall(Husk husk) {
        float f = husk.m_6972_((Pose)husk.m_20089_()).f_20377_ * 0.8f;
        AABB aabb = AABB.m_165882_((Vec3)husk.m_146892_(), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.m_121921_((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = husk.m_9236_().m_8055_(p_201942_);
            return !blockstate.m_60795_() && blockstate.m_60828_((BlockGetter)husk.m_9236_(), p_201942_) && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)husk.m_9236_(), p_201942_).m_83216_((double)p_201942_.m_123341_(), (double)p_201942_.m_123342_(), (double)p_201942_.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public static enum BurrowPhases {
        START,
        BURROW,
        GRAB,
        SINK,
        DIG_OUT,
        END,
        STOP;

    }
}

