/*
 * Decompiled with CFR 0.152.
 */
package energon.srpquark.custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import energon.srpextra.custom.SRPEFile;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SRPQuarkFile {
    private static List<String> SRPQuarkSTR = Arrays.asList("ship_hi_pirate;srpquark;gg", "ships_hi_pirate;srpquark;gg");

    public static void readFile() {
        File customDir;
        SRPQuarkFile test = new SRPQuarkFile();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            customDir = new File(Minecraft.func_71410_x().field_71412_D, "srpextra");
        } else {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                customDir = new File(server.func_71238_n(), "srpextra");
            } else {
                return;
            }
        }
        test.check(customDir);
        SRPEFile.addonStructures((File)customDir, SRPQuarkSTR);
    }

    private void check(File customDir) {
        block30: {
            if (!customDir.exists()) {
                customDir.mkdirs();
            }
            File fileConfig = new File(customDir, "config_srpquark.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                if (!fileConfig.exists()) {
                    JsonArray jsonArray = new JsonArray();
                    for (String nn : SRPQuarkSTR) {
                        jsonArray.add(nn.split(";")[0]);
                        this.include(customDir, nn);
                    }
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.add("Structures", (JsonElement)jsonArray);
                    jsonObject.addProperty("Version", "1.3.2");
                    try (FileWriter writer = new FileWriter(fileConfig);){
                        gson.toJson((JsonElement)jsonObject, (Appendable)writer);
                        break block30;
                    }
                }
                try (FileReader reader = new FileReader(fileConfig);){
                    SRPQuarkSTR = new ArrayList<String>();
                    for (JsonElement parts : ((JsonObject)gson.fromJson((Reader)reader, JsonObject.class)).getAsJsonArray("Structures")) {
                        SRPQuarkSTR.add(parts.getAsString());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void include(File customDir, String element) {
        Throwable throwable;
        InputStream input2;
        String name = element.split(";")[0];
        String dir = element.split(";")[1];
        try {
            input2 = this.getClass().getResourceAsStream("/assets/" + dir + "/custom/" + name + ".json");
            throwable = null;
            try {
                if (input2 != null) {
                    Files.copy(input2, new File(customDir, name + ".json").toPath(), new CopyOption[0]);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input2 != null) {
                    if (throwable != null) {
                        try {
                            input2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        input2.close();
                    }
                }
            }
        }
        catch (IOException input2) {
            // empty catch block
        }
        if (element.split(";").length == 2) {
            try {
                input2 = this.getClass().getResourceAsStream("/assets/" + dir + "/custom/" + name + ".nbt");
                throwable = null;
                try {
                    if (input2 != null) {
                        Files.copy(input2, new File(customDir, name + ".nbt").toPath(), new CopyOption[0]);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (input2 != null) {
                        if (throwable != null) {
                            try {
                                input2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            input2.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

