/*
 * Decompiled with CFR 0.152.
 */
package energon.srpquark.init;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import energon.srpquark.config.SRPQuarkConfigMobs;
import energon.srpquark.entity.EntityHiAshen;
import energon.srpquark.entity.EntityHiPirate;
import energon.srpquark.entity.EntityInfArchaeologist;
import energon.srpquark.entity.EntityInfCrab;
import energon.srpquark.entity.EntityInfDweller;
import energon.srpquark.entity.EntityInfFrog;
import energon.srpquark.entity.EntityInfStoneling;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SRPQuarkEntities {
    public static EntityEntry[] ENTITIES;

    private static <T extends Entity> EntityEntry CreateEntityMob(String name, Class<T> cls, int id, boolean active) {
        if (!active) {
            return null;
        }
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.entity(cls);
        builder.name("srpquark." + name);
        builder.id(new ResourceLocation("srparasites", name), id);
        builder.tracker(64, 3, true);
        if (SRPConfig.vanillaEggs) {
            builder.egg(8611072, 16711900);
        }
        return builder.build();
    }

    @Mod.EventBusSubscriber(modid="srpquark")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void onEvent(RegistryEvent.Register<EntityEntry> event) {
            IForgeRegistry registry = event.getRegistry();
            int cc = 0;
            ENTITIES = new EntityEntry[]{SRPQuarkEntities.CreateEntityMob("hi_pirate", EntityHiPirate.class, ++cc, SRPQuarkConfigMobs.active_hijacked_skeleton_pirate), SRPQuarkEntities.CreateEntityMob("hi_ashen", EntityHiAshen.class, ++cc, SRPQuarkConfigMobs.active_hijacked_skeleton_ashen), SRPQuarkEntities.CreateEntityMob("sim_dweller", EntityInfDweller.class, ++cc, SRPQuarkConfigMobs.active_sim_dweller), SRPQuarkEntities.CreateEntityMob("sim_archaeologist", EntityInfArchaeologist.class, ++cc, SRPQuarkConfigMobs.active_sim_archaeologist), SRPQuarkEntities.CreateEntityMob("sim_stoneling", EntityInfStoneling.class, ++cc, SRPQuarkConfigMobs.active_sim_stoneling), SRPQuarkEntities.CreateEntityMob("sim_crab", EntityInfCrab.class, ++cc, SRPQuarkConfigMobs.active_sim_crab), SRPQuarkEntities.CreateEntityMob("sim_frog", EntityInfFrog.class, ++cc, SRPQuarkConfigMobs.active_sim_frog)};
            for (int i = 0; i < ENTITIES.length; ++i) {
                if (ENTITIES[i] == null) continue;
                registry.register((IForgeRegistryEntry)ENTITIES[i]);
            }
        }
    }
}

